% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rforcecom.createBulkJob.R
\name{rforcecom.createBulkJob}
\alias{rforcecom.createBulkJob}
\title{Create Bulk API Job}
\usage{
rforcecom.createBulkJob(session,
                               operation=c('insert', 'delete',
                                           'query', 'upsert',
                                           'update', 'hardDelete'),
                               object='Account',
                               concurrencyMode='Parallel')
}
\arguments{
\item{session}{a named character vector defining parameters of the api connection as returned by \link{rforcecom.login}}

\item{operation}{a character string defining the type of operation being performed}

\item{object}{a character string defining the target salesforce object that the operation will be performed on}

\item{concurrencyMode}{a character string either "Parallel" or "Serial" that specifies whether batches should be completed
sequentially or in parallel. Use "Serial" only if Lock contentions persist with in "Parallel" mode.}
}
\value{
A \code{list} parameters defining the created job, including id
}
\description{
This function initializes a Job in the Salesforce Bulk API
}
\examples{
\dontrun{
# insert into Account
job_info <- rforcecom.createBulkJob(session, operation='insert', object='Account')

# delete from Account
job_info <- rforcecom.createBulkJob(session, operation='delete', object='Account')

# insert attachments
job_info <- rforcecom.createBulkJob(session, operation='insert', object='Attachment')
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
\concept{
bulk job salesforce api
}

