% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rforcecom.insertBulkAttachments.R
\name{rforcecom.insertBulkAttachments}
\alias{rforcecom.insertBulkAttachments}
\title{Insert Attachments via Bulk API Job}
\usage{
rforcecom.insertBulkAttachments(session, jobId, file)
}
\arguments{
\item{session}{a named character vector defining parameters of the api connection as returned by \link{rforcecom.login}}

\item{jobId}{a character string defining the salesforce id assigned to a submitted job as returned by \link{rforcecom.createBulkJob}}

\item{file}{a file path to a .zip file containing request.txt manifest formatted as CSV and any binary attachments. It should
have request.txt in the top-level (aka base) directory. Attachment files can be in subdirectories if desired. See Salesforce
documentation for details on how to format the .zip file.}
}
\value{
A \code{list} of parameters defining the created batch
}
\description{
This function takes a file path to a structured .zip file of attachments and submits it to
an already existing Bulk API Job
}
\examples{
\dontrun{

# sample .zip directory structure
request.zip
  request.txt
  attachment1.gif
  subdir/
    attachment2.doc

# sample format of request.txt
Name,ParentId,Body
attachment1.gif,TheTargetRecordIdHere,#attachment1.gif
subdir/attachment2.doc,TheTargetRecordIdHere,#subdir/attachment2.doc

f <- 'request.zip'
batch_attachment_info <- rforcecom.insertBulkAttachments(session, jobId=job_info$id, file=f)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
\concept{
bulk batch salesforce api
}

