% Generated by roxygen2 (4.0.1): do not edit by hand
\name{get_goals}
\alias{get_goals}
\title{Lists  Lists goals which the user has access to}
\usage{
get_goals(account.id = "~all", webproperty.id = "~all",
  profile.id = "~all", start.index = NULL, max.results = NULL, token,
  verbose = getOption("rga.verbose", FALSE))
}
\arguments{
\item{account.id}{character. The account ID to retrieve goals for. Can either be a specific account ID or '~all', which refers to all the accounts that user has access to.}

\item{webproperty.id}{character. Web property ID to retrieve goals for. Can either be a specific web property ID or '~all', which refers to all the web properties that user has access to. Requires specified \code{account.id}.}

\item{profile.id}{character. View (Profile) ID to retrieve goals for. Can either be a specific view (profile) ID or '~all', which refers to all the views (profiles) that user has access to. Requires specified \code{account.id} and \code{webproperty.id}.}

\item{start.index}{integer. An index of the first goal to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.}

\item{max.results}{integer. The maximum number of goals to include in this response.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}

\item{verbose}{logical. Should print information verbose?}
}
\value{
A data frame with Google Analytics management data.
\item{accountId}{account ID which this goal belongs to.}
\item{webPropertyId}{web property ID which this goal belongs to. The web property ID is of the form UA-XXXXX-YY.}
\item{profileId}{view (Profile) ID to which this goal belongs.}
\item{id}{goal ID (number).}
\item{name}{goal name.}
\item{value}{goal value.}
\item{active}{determines whether this goal is active.}
\item{type}{goal type. Acceptable values are: "EVENT", "URL_DESTINATION", "VISIT_NUM_PAGES", "VISIT_TIME_ON_SITE"}
\item{created}{time this goal was created.}
\item{updated}{time this goal was last modified.}
}
\description{
Lists  Lists goals which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/goals}{Google Management API - Goals}
}
\seealso{
\code{\link{authorize}}

Other The.Google.Analytics.Management.API: \code{\link{get_accounts}};
  \code{\link{get_profiles}}; \code{\link{get_segments}};
  \code{\link{get_webproperties}}
}

