% Generated by roxygen2 (4.0.1): do not edit by hand
\name{get_mcf}
\alias{get_mcf}
\title{Get the Anaytics data from Multi-Channel Funnels Reporting API for a view (profile)}
\usage{
get_mcf(profile.id, start.date = "7daysAgo", end.date = "yesterday",
  metrics = "mcf:totalConversions", dimensions = NULL, sort = NULL,
  filters = NULL, start.index = NULL, max.results = NULL, token,
  verbose = getOption("rga.verbose", FALSE))
}
\arguments{
\item{profile.id}{string or integer. Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the Analytics view (profile) ID.}

\item{start.date}{character. Start date for fetching Analytics data. Request can specify a start date formatted as YYYY-MM-DD or as a relative date (e.g., today, yesterday, or 7daysAgo). The default value is 7daysAgo.}

\item{end.date}{character. End date for fetching Analytics data. Request can specify an end date formatted as YYYY-MM-DD or as a relative date (e.g., today, yester-day, or 7daysAgo). The default value is yesterday.}

\item{metrics}{character. A comma-separated list of Multi-Channel Funnels metrics. E.g., \code{"mcf:totalConversions,mcf:totalConversionValue"}. At least one metric must be specified.}

\item{dimensions}{character. A comma-separated list of Multi-Channel Funnels dimensions. E.g., code{"mcf:source,mcf:medium"}.}

\item{sort}{character. character. A comma-separated list of dimensions or metrics that determine the sort order for Analytics data.}

\item{filters}{character. A comma-separated list of dimension or metric filters to be applied to Analytics data.}

\item{start.index}{integer. An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.}

\item{max.results}{integer. The maximum number of entries to include in this feed.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}

\item{verbose}{logical. Should print information verbose?}
}
\value{
A data frame including the Analytics Multi-Channel Funnels data for a view (profile)
}
\description{
Get the Anaytics data from Multi-Channel Funnels Reporting API for a view (profile)
}
\examples{
\dontrun{
# get token data
authorize(client.id = "myID", client.secret = "mySecret")
# get report data
ga_data <- get_mcf("myProfileID", start.date = "30daysAgo", end.date = "today",
                   metrics = "mcf:totalConversions",
                   dimensions = "mcf:totalConversions,mcf:totalConversionValue")
}
}
\references{
\href{https://developers.google.com/analytics/devguides/reporting/mcf/dimsmets/}{Multi-Channel Funnels Reporting API - Dimensions & Metrics Reference}
}
\seealso{
\code{\link{authorize}}

Other The.Google.Analytics.Reporting.API: \code{\link{get_firstdate}};
  \code{\link{get_ga}}; \code{\link{get_report}};
  \code{\link{get_rt}}
}

