% Generated by roxygen2 (4.0.2): do not edit by hand
\name{get_segments}
\alias{get_segments}
\title{Lists segments which the user has access to}
\usage{
get_segments(start.index = NULL, max.results = NULL, token,
  verbose = getOption("rga.verbose", FALSE))
}
\arguments{
\item{start.index}{integer. An index of the first segment to retrieve. Use this parameter as a pagi- nation mechanism along with the max-results parameter.}

\item{max.results}{integer. The maximum number of segments to include in this response.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}

\item{verbose}{logical. Should print information verbose?}
}
\value{
A data frame with Google Analytics management data.
\item{id}{segment ID.}
\item{segmentId}{segment ID. Can be used with the segment parameter in Data Feed.}
\item{name}{segment name.}
\item{definition}{segment definition.}
\item{type}{type for a segment. Possible values are "BUILT_IN" or "CUSTOM".}
\item{created}{time the segment was created.}
\item{updated}{time the segment was last modified.}
}
\description{
Lists segments which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/segments}{Google Management API - Segments}

\href{https://developers.google.com/analytics/devguides/reporting/core/v3/segments}{Core Reporting API - Segments}
}
\seealso{
\code{\link{authorize}}

Other The.Google.Analytics.Management.API: \code{\link{get_accounts}};
  \code{\link{get_goals}}; \code{\link{get_profiles}};
  \code{\link{get_webproperties}}
}

