% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genSmoothingCovIMA.R
\name{genSmoothingCovIMA}
\alias{genSmoothingCovIMA}
\title{Fill data gaps and smooth outliers in a time series of satellite images using
covariates}
\usage{
genSmoothingCovIMA(rStack, cStack, Img2Process = NULL, nDays = 3,
  nYears = 1, fact = 5, fun = mean, aFilter = c(0.05, 0.95),
  snow.mode = FALSE, out.name = "out", ...)
}
\arguments{
\item{rStack}{a \code{RasterStack} class argument containing a time series of
satellite images. Layer names should contain the date of the image in
 "\code{YYYYJJJ}" format.}

\item{cStack}{a \code{RasterStack} class argument containing a time series of
covariates.}

\item{Img2Process}{a \code{vector} class argument defining the images to be
filled/smoothed.}

\item{nDays}{a \code{numeric} argument with the number of previous and 
subsequent days that define the temporal neighborhood.}

\item{nYears}{a \code{numeric} argument with the number of previous and
subsequent years that define the temporal neighborhood.}

\item{fact}{a \code{numeric} argument with an aggregation factor of the
anomalies carried out before the interpolation.}

\item{fun}{a \code{function} used to aggregate the image of anomalies. Both
\code{mean}(default) or \code{median} are acceptted.}

\item{aFilter}{a \code{vector} with the lower and upper quantiles that define
the outliers of the anomalies. Ex. c(0.05,0.95).}

\item{snow.mode}{logical argument. If \code{TRUE}, the filling process will
be parallelized using the `\code{raster}' package.}

\item{out.name}{the name of the folder containing the filled/smoothed images
when saved in the Hard Disk Drive (HDD).}

\item{...}{arguments for nested functions:
\itemize{
  \item \code{AppRoot} the path where the filled/smoothed time series of 
  images are saved in GTiff format.
}}
}
\value{
a \code{RasterStack} with the filled/smoothed images.
}
\description{
\code{genSmoothingCovIMA} runs the image mean anomaly (IMA) algorithm
with covariates \insertCite{militino2018improving}{RGISTools}.
}
\details{
This filling/smoothing method was developed by 
\insertCite{militino2018improving;textual}{RGISTools}. This technique 
decomposes a time series of images into a new series of mean and anomaly 
images. The procedure applies the filling/smoothing algorithm with covariates
over the anomaly images. The procedure requires a proper definition of a
temporal neighbourhood for the target image and aggregation factor.
}
\examples{
set.seed(0)
# load example ndvi and dem data of Navarre
data(ex.ndvi.navarre)
data(ex.dem.navarre)
# plot example data
genPlotGIS(ex.ndvi.navarre)
genPlotGIS(ex.dem.navarre)

# distorts 5\% of the original ndvi data by 
# altering 50\% its values
for(x in c(2,5)){
  aux <- sampleRandom(ex.ndvi.navarre[[x]],
                      ncell(ex.ndvi.navarre) * 0.05,
                      cells = TRUE,
                      na.rm = TRUE)
  ex.ndvi.navarre[[x]][aux[,1]] <- aux[,2] * 1.5
}
genPlotGIS(ex.ndvi.navarre)

# smoothing the image using the DEM as covariate
smth.ndvi <- genSmoothingCovIMA(rStack = ex.ndvi.navarre,
                                cStack = ex.dem.navarre,
                                Img2Process = c(2,5))
# plot the distorted 1, smoothed 1, 
# distorted 5, smoothed 5 images
plot(stack(ex.ndvi.navarre[[2]],
                 smth.ndvi[[1]],
                 ex.ndvi.navarre[[5]],
                 smth.ndvi[[2]]))
}
\references{
\insertRef{militino2018improving}{RGISTools}
}
