% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsEspaDownloadOrders.R
\name{lsEspaDownloadOrders}
\alias{lsEspaDownloadOrders}
\title{Downloads the images that have been pre-processed by ESPA}
\usage{
lsEspaDownloadOrders(orders, AppRoot, username = NULL, password = NULL,
  c.handle = NULL, verbose = FALSE, overwrite = FALSE,
  n.attempts = 5, untar = FALSE, ...)
}
\arguments{
\item{orders}{a list of the requested images as returned by
\code{\link{lsEspaGetOrderImages}}.}

\item{AppRoot}{the download directory.}

\item{username}{USGS's `EarthExplorer' username.}

\item{password}{USGS's `EarthExplorer' password.}

\item{c.handle}{a curl handler created with the package `\code{curl}' to stablish
a connection with a preset password and username. This argument is mandatory
if \code{username} and \code{password} are not defined.}

\item{verbose}{logical argument. If TRUE, the function prints the running 
steps and warnings.}

\item{overwrite}{logical argument. If TRUE, overwrites the existing images
with the same name.}

\item{n.attempts}{the number of attempts to download an image in case it
becomes corrupted files.}

\item{untar}{logical argument. If TRUE, untars the downloaded images.}

\item{...}{argument for nested functions}
}
\value{
this function does not return anything. It saves the imagery as
`tar.gz’ (and GTiff files) in a folder called `raw’ (`untar’) in the
 \code{AppRoot} directory.
}
\description{
\code{lsEspaDownloadOrders} downloads a set of images processed by the EROS
Centre Science Processing Architecture (ESPA) through its application
programming interface (API).
}
\details{
This function is part of a group of functions used to pre-process Landsat
level-1 images. The pre-processing is carried out by ESPA on demand. 
\code{\link{lsEspaDownloadOrders}} downloads the images whose processing was
completed according to \code{\link{lsEspaUpdateOrders}}. The function 
downloads and saves the imagery under the \code{AppRoot} directory. The
function automatically creates two folders, called "raw" and "untar", to 
save the compressed and decompressed images respectively. The imagery is only
decompressed when \code{untar = TRUE}.
}
\examples{
\dontrun{
wdir <- file.path(tempdir(),"Path_for_downloading_folder")
print(wdir)
# search Landsat-7 level-1
sres <- ls7Search(startDate = as.Date("01-01-2017", "\%d-\%m-\%Y"),
                  endDate = as.Date("15-01-2017", "\%d-\%m-\%Y"),
                  lonlat = c(-1.64323, 42.81687),
                  AppRoot = wdir)
# request to ESPA the prepocessing of level-1 images to get the surface reflectance
order <- lsEspaOrderImages(search.res = sres,
                           username = "username", 
                           password = "password", 
                           product = 'sr',
                           verbose = FALSE)
# get an ID for our request
orders <- lsEspaGetOrderImages(username = "username", 
                               password = "password")
# follow up the status of the request
orders <- lsEspaUpdateOrders(orders = orders,
                             username = "username", 
                             password = "password")
# saving directory
wdir.ls7.ESPA <- file.path(wdir,"Landsat7","ESPA")
dir.create(wdir.ls7.ESPA, recursive = TRUE)
# download when status says: complete
lsEspaDownloadOrders(orders = orders,
                     username = "username", 
                     password = "password",
                     untar = TRUE,
                     AppRoot = wdir.ls7.ESPA)
}
}
