#' Retrieve the list of Profiles for the Google Analytics Account
#' 
#' This function retrieves all the available profiles from the 
#' Google analytics account.
#' Before retrieving the list of profiles, this function checks whether the token 
#' is valid and regenerates it if required
#'  
#' @export
#' 
#' @param token Token Object generated by \code{\link{Auth}}
#' 
#' @return R dataframe with profile ID and profile name.

GetProfiles <- function(token) {
  
  ValidateToken(token)
  
  query.uri <- paste0('https://www.googleapis.com/analytics/v3/',
                      'management/accounts/~all/webproperties/~all/',
                      'profiles?access_token=',
                      token$credentials$access_token
  )
  if (!is.character(query.uri)) {
    stop("The query.uri parameter must be a character string")
  }
  
  # This api.reponse should be in json format
  api.response.json <- GetAcctDataFeedJSON(query.uri)
  profiles.param <- GetProfilesFromJSON(api.response.json)
  return(profiles.param$profiles)
}