/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.process.StackStatistics;

public class ContrastEnhancer
implements PlugIn,
Measurements {
    int max;
    int range;
    boolean classicEqualization;
    int stackSize;
    boolean updateSelectionOnly;
    boolean equalize;
    boolean normalize;
    boolean processStack;
    boolean useStackHistogram;
    boolean entireImage;
    static double saturated = 0.5;
    static boolean gEqualize;
    static boolean gNormalize;

    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        this.stackSize = imp.getStackSize();
        imp.trimProcessor();
        if (!this.showDialog(imp)) {
            return;
        }
        Roi roi = imp.getRoi();
        if (roi != null) {
            roi.endPaste();
        }
        if (this.stackSize == 1) {
            Undo.setup(6, imp);
        } else {
            Undo.reset();
        }
        if (this.equalize) {
            this.equalize(imp);
        } else {
            this.stretchHistogram(imp, saturated);
        }
        if (this.equalize || this.normalize) {
            imp.getProcessor().resetMinAndMax();
        }
        imp.updateAndDraw();
    }

    boolean showDialog(ImagePlus imp) {
        Roi roi;
        this.equalize = gEqualize;
        this.normalize = gNormalize;
        int bitDepth = imp.getBitDepth();
        boolean composite = imp.isComposite();
        if (composite) {
            this.stackSize = 1;
        }
        boolean areaRoi = (roi = imp.getRoi()) != null && roi.isArea() && !composite;
        GenericDialog gd = new GenericDialog("Enhance Contrast");
        gd.addNumericField("Saturated Pixels:", saturated, 1, 4, "%");
        if (bitDepth != 24 && !composite) {
            gd.addCheckbox("Normalize", this.normalize);
        }
        if (areaRoi) {
            String label = bitDepth == 24 ? "Update Entire Image" : "Update All When Normalizing";
            gd.addCheckbox(label, this.entireImage);
        }
        gd.addCheckbox("Equalize Histogram", this.equalize);
        if (this.stackSize > 1) {
            if (!composite) {
                gd.addCheckbox("Normalize_All " + this.stackSize + " Slices", this.processStack);
            }
            gd.addCheckbox("Use Stack Histogram", this.useStackHistogram);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        saturated = gd.getNextNumber();
        this.normalize = bitDepth != 24 && !composite ? gd.getNextBoolean() : false;
        if (areaRoi) {
            this.entireImage = gd.getNextBoolean();
            boolean bl = this.updateSelectionOnly = !this.entireImage;
            if (!this.normalize && bitDepth != 24) {
                this.updateSelectionOnly = false;
            }
        }
        this.equalize = gd.getNextBoolean();
        this.processStack = this.stackSize > 1 ? gd.getNextBoolean() : false;
        boolean bl = this.useStackHistogram = this.stackSize > 1 ? gd.getNextBoolean() : false;
        if (saturated < 0.0) {
            saturated = 0.0;
        }
        if (saturated > 100.0) {
            saturated = 100.0;
        }
        if (this.processStack) {
            this.normalize = true;
        }
        gEqualize = this.equalize;
        gNormalize = this.normalize;
        return true;
    }

    public void stretchHistogram(ImagePlus imp, double saturated) {
        ImageStatistics stats = null;
        if (this.useStackHistogram) {
            stats = new StackStatistics(imp);
        }
        if (this.processStack) {
            ImageStack stack = imp.getStack();
            for (int i = 1; i <= this.stackSize; ++i) {
                IJ.showProgress(i, this.stackSize);
                ImageProcessor ip = stack.getProcessor(i);
                ip.setRoi(imp.getRoi());
                if (!this.useStackHistogram) {
                    stats = ImageStatistics.getStatistics(ip, 16, null);
                }
                this.stretchHistogram(ip, saturated, stats);
            }
        } else {
            ImageProcessor ip = imp.getProcessor();
            ip.setRoi(imp.getRoi());
            if (stats == null) {
                stats = ImageStatistics.getStatistics(ip, 16, null);
            }
            if (imp.isComposite()) {
                this.stretchCompositeImageHistogram((CompositeImage)imp, saturated, stats);
            } else {
                this.stretchHistogram(ip, saturated, stats);
            }
        }
    }

    public void stretchHistogram(ImageProcessor ip, double saturated) {
        this.useStackHistogram = false;
        this.stretchHistogram(new ImagePlus("", ip), saturated);
    }

    public void stretchHistogram(ImageProcessor ip, double saturated, ImageStatistics stats) {
        int hmin;
        int[] a = this.getMinAndMax(ip, saturated, stats);
        int hmax = a[1];
        if (hmax > (hmin = a[0])) {
            double min = stats.histMin + (double)hmin * stats.binSize;
            double max = stats.histMin + (double)hmax * stats.binSize;
            if (!this.updateSelectionOnly) {
                ip.resetRoi();
            }
            if (this.normalize) {
                this.normalize(ip, min, max);
            } else if (this.updateSelectionOnly) {
                ImageProcessor mask = ip.getMask();
                if (mask != null) {
                    ip.snapshot();
                }
                ip.setMinAndMax(min, max);
                if (mask != null) {
                    ip.reset(mask);
                }
            } else {
                ip.setMinAndMax(min, max);
            }
        }
    }

    void stretchCompositeImageHistogram(CompositeImage imp, double saturated, ImageStatistics stats) {
        int hmin;
        ImageProcessor ip = imp.getProcessor();
        int[] a = this.getMinAndMax(ip, saturated, stats);
        int hmax = a[1];
        if (hmax > (hmin = a[0])) {
            double min = stats.histMin + (double)hmin * stats.binSize;
            double max = stats.histMin + (double)hmax * stats.binSize;
            imp.setDisplayRange(min, max);
        }
    }

    int[] getMinAndMax(ImageProcessor ip, double saturated, ImageStatistics stats) {
        int[] histogram = stats.histogram;
        int threshold = saturated > 0.0 ? (int)((double)stats.pixelCount * saturated / 200.0) : 0;
        int i = -1;
        boolean found = false;
        int count = 0;
        do {
            boolean bl = found = (count += histogram[++i]) > threshold;
        } while (!found && i < 255);
        int hmin = i;
        i = 256;
        count = 0;
        do {
            boolean bl = found = (count += histogram[--i]) > threshold;
        } while (!found && i > 0);
        int hmax = i;
        int[] a = new int[]{hmin, hmax};
        return a;
    }

    void normalize(ImageProcessor ip, double min, double max) {
        boolean min2 = false;
        int max2 = 255;
        int range = 256;
        if (ip instanceof ShortProcessor) {
            max2 = 65535;
            range = 65536;
        } else if (ip instanceof FloatProcessor) {
            this.normalizeFloat(ip, min, max);
        }
        int[] lut = new int[range];
        for (int i = 0; i < range; ++i) {
            lut[i] = (double)i <= min ? 0 : ((double)i >= max ? max2 : (int)(((double)i - min) / (max - min) * (double)max2));
        }
        this.applyTable(ip, lut);
    }

    void applyTable(ImageProcessor ip, int[] lut) {
        if (this.updateSelectionOnly) {
            ImageProcessor mask = ip.getMask();
            if (mask != null) {
                ip.snapshot();
            }
            ip.applyTable(lut);
            if (mask != null) {
                ip.reset(mask);
            }
        } else {
            ip.applyTable(lut);
        }
    }

    void normalizeFloat(ImageProcessor ip, double min, double max) {
        double scale = max > min ? 1.0 / (max - min) : 1.0;
        int size = ip.getWidth() * ip.getHeight();
        float[] pixels = (float[])ip.getPixels();
        for (int i = 0; i < size; ++i) {
            double v = (double)pixels[i] - min;
            if (v < 0.0) {
                v = 0.0;
            }
            if ((v *= scale) > 1.0) {
                v = 1.0;
            }
            pixels[i] = (float)v;
        }
    }

    public void equalize(ImagePlus imp) {
        if (imp.getBitDepth() == 32) {
            IJ.showMessage("Contrast Enhancer", "Equalization of 32-bit images not supported.");
            return;
        }
        this.classicEqualization = IJ.altKeyDown();
        if (this.processStack) {
            ImageStack stack = imp.getStack();
            for (int i = 1; i <= this.stackSize; ++i) {
                IJ.showProgress(i, this.stackSize);
                ImageProcessor ip = stack.getProcessor(i);
                this.equalize(ip);
            }
        } else {
            this.equalize(imp.getProcessor());
        }
    }

    public void equalize(ImageProcessor ip) {
        int[] histogram = ip.getHistogram();
        ip.resetRoi();
        if (ip instanceof ShortProcessor) {
            this.max = 65535;
            this.range = 65535;
        } else {
            this.max = 255;
            this.range = 255;
        }
        double sum = this.getWeightedValue(histogram, 0);
        for (int i = 1; i < this.max; ++i) {
            sum += 2.0 * this.getWeightedValue(histogram, i);
        }
        double scale = (double)this.range / (sum += this.getWeightedValue(histogram, this.max));
        int[] lut = new int[this.range + 1];
        lut[0] = 0;
        sum = this.getWeightedValue(histogram, 0);
        for (int i = 1; i < this.max; ++i) {
            double delta = this.getWeightedValue(histogram, i);
            lut[i] = (int)Math.round((sum += delta) * scale);
            sum += delta;
        }
        lut[this.max] = this.max;
        this.applyTable(ip, lut);
    }

    private double getWeightedValue(int[] histogram, int i) {
        int h = histogram[i];
        if (h < 2 || this.classicEqualization) {
            return h;
        }
        return Math.sqrt(h);
    }
}

