/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.gui.ImageWindow;
import ij.gui.NewImage;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.text.TextWindow;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.CharArrayWriter;
import java.io.PrintWriter;

public class HistogramWindow
extends ImageWindow
implements Measurements,
ActionListener,
ClipboardOwner {
    static final int WIN_WIDTH = 300;
    static final int WIN_HEIGHT = 240;
    static final int HIST_WIDTH = 256;
    static final int HIST_HEIGHT = 128;
    static final int BAR_HEIGHT = 12;
    static final int XMARGIN = 20;
    static final int YMARGIN = 10;
    protected ImageStatistics stats;
    protected int[] histogram;
    protected LookUpTable lut;
    protected Rectangle frame = null;
    protected Button list;
    protected Button save;
    protected Button copy;
    protected Button log;
    protected Label value;
    protected Label count;
    protected static String defaultDirectory = null;
    protected int decimalPlaces;
    protected int digits;
    protected int newMaxCount;
    protected int plotScale = 1;
    protected boolean logScale;
    protected Calibration cal;
    protected int yMax;
    public static int nBins = 256;

    public HistogramWindow(ImagePlus imagePlus) {
        super(NewImage.createByteImage("Histogram of " + imagePlus.getShortTitle(), 300, 240, 1, 4));
        this.showHistogram(imagePlus, 256, 0.0, 0.0);
    }

    public HistogramWindow(String string, ImagePlus imagePlus, int n) {
        super(NewImage.createByteImage(string, 300, 240, 1, 4));
        this.showHistogram(imagePlus, n, 0.0, 0.0);
    }

    public HistogramWindow(String string, ImagePlus imagePlus, int n, double d, double d2) {
        super(NewImage.createByteImage(string, 300, 240, 1, 4));
        this.showHistogram(imagePlus, n, d, d2);
    }

    public HistogramWindow(String string, ImagePlus imagePlus, int n, double d, double d2, int n2) {
        super(NewImage.createByteImage(string, 300, 240, 1, 4));
        this.yMax = n2;
        this.showHistogram(imagePlus, n, d, d2);
    }

    public HistogramWindow(String string, ImagePlus imagePlus, ImageStatistics imageStatistics) {
        super(NewImage.createByteImage(string, 300, 240, 1, 4));
        this.yMax = imageStatistics.histYMax;
        this.showHistogram(imagePlus, imageStatistics);
    }

    public void showHistogram(ImagePlus imagePlus, int n) {
        this.showHistogram(imagePlus, n, 0.0, 0.0);
    }

    public void showHistogram(ImagePlus imagePlus, int n, double d, double d2) {
        boolean bl = (Analyzer.getMeasurements() & 0x100) != 0;
        this.stats = imagePlus.getStatistics(27 + (bl ? 256 : 0), n, d, d2);
        this.showHistogram(imagePlus, this.stats);
    }

    public void showHistogram(ImagePlus imagePlus, ImageStatistics imageStatistics) {
        int n;
        int n2;
        ImageProcessor imageProcessor;
        this.setup();
        this.stats = imageStatistics;
        this.cal = imagePlus.getCalibration();
        boolean bl = (Analyzer.getMeasurements() & 0x100) != 0;
        imagePlus.getMask();
        this.histogram = imageStatistics.histogram;
        if (bl && this.histogram.length == 256 && (imageProcessor = imagePlus.getProcessor()).getMinThreshold() != -808080.0) {
            n2 = this.scaleDown(imageProcessor, imageProcessor.getMinThreshold());
            int n3 = this.scaleDown(imageProcessor, imageProcessor.getMaxThreshold());
            for (n = 0; n < n2; ++n) {
                this.histogram[n] = 0;
            }
            for (n = n3 + 1; n < 256; ++n) {
                this.histogram[n] = 0;
            }
        }
        this.lut = imagePlus.createLut();
        int n4 = imagePlus.getType();
        n2 = n4 == 0 || n4 == 3 || n4 == 4 ? 1 : 0;
        ImageProcessor imageProcessor2 = this.imp.getProcessor();
        int n5 = n = !(imagePlus.getProcessor() instanceof ColorProcessor) && !this.lut.isGrayscale() ? 1 : 0;
        if (n != 0) {
            imageProcessor2 = imageProcessor2.convertToRGB();
        }
        this.drawHistogram(imageProcessor2, n2 != 0);
        if (n != 0) {
            this.imp.setProcessor(null, imageProcessor2);
        } else {
            this.imp.updateAndDraw();
        }
    }

    public void setup() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        this.list = new Button("List");
        this.list.addActionListener(this);
        panel.add(this.list);
        this.copy = new Button("Copy");
        this.copy.addActionListener(this);
        panel.add(this.copy);
        this.log = new Button("Log");
        this.log.addActionListener(this);
        panel.add(this.log);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(2, 1));
        this.value = new Label("                  ");
        this.value.setFont(new Font("Monospaced", 0, 12));
        panel2.add(this.value);
        this.count = new Label("                  ");
        this.count.setFont(new Font("Monospaced", 0, 12));
        panel2.add(this.count);
        panel.add(panel2);
        this.add(panel);
        this.pack();
    }

    public void mouseMoved(int n, int n2) {
        if (this.value == null || this.count == null) {
            return;
        }
        if (this.frame != null && n >= this.frame.x && n <= this.frame.x + this.frame.width) {
            if ((n -= this.frame.x) > 255) {
                n = 255;
            }
            int n3 = (int)((double)n * (double)this.histogram.length / 256.0);
            this.value.setText("  Value: " + ResultsTable.d2s(this.cal.getCValue(this.stats.histMin + (double)n3 * this.stats.binSize), this.digits));
            this.count.setText("  Count: " + this.histogram[n3]);
        } else {
            this.value.setText("");
            this.count.setText("");
        }
    }

    protected void drawHistogram(ImageProcessor imageProcessor, boolean bl) {
        int n = 0;
        int n2 = 0;
        imageProcessor.setColor(Color.black);
        imageProcessor.setLineWidth(1);
        this.decimalPlaces = Analyzer.getPrecision();
        this.digits = this.cal.calibrated() || this.stats.binSize != 1.0 ? this.decimalPlaces : 0;
        int n3 = this.histogram[this.stats.mode];
        for (int i = 0; i < this.histogram.length; ++i) {
            if (this.histogram[i] <= n || i == this.stats.mode) continue;
            n = this.histogram[i];
            n2 = i;
        }
        this.newMaxCount = this.stats.maxCount;
        if (this.newMaxCount > n * 2 && n != 0) {
            this.newMaxCount = (int)((double)n * 1.5);
        }
        if (IJ.shiftKeyDown()) {
            this.logScale = true;
            this.drawLogPlot(this.yMax > 0 ? this.yMax : this.newMaxCount, imageProcessor);
        }
        this.drawPlot(this.yMax > 0 ? this.yMax : this.newMaxCount, imageProcessor);
        this.histogram[this.stats.mode] = n3;
        int n4 = 21;
        int n5 = 140;
        this.lut.drawUnscaledColorBar(imageProcessor, n4 - 1, n5, 256, 12);
        this.drawText(imageProcessor, n4, n5 += 27, bl);
    }

    int scaleDown(ImageProcessor imageProcessor, double d) {
        double d2 = imageProcessor.getMin();
        double d3 = imageProcessor.getMax();
        if (d3 > d2) {
            return (int)((d - d2) / (d3 - d2) * 255.0);
        }
        return 0;
    }

    void drawPlot(int n, ImageProcessor imageProcessor) {
        if (n == 0) {
            n = 1;
        }
        this.frame = new Rectangle(20, 10, 256, 128);
        imageProcessor.drawRect(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height + 1);
        for (int i = 0; i < 256; ++i) {
            int n2 = (int)((double)i * (double)this.histogram.length / 256.0);
            int n3 = (int)(128.0 * (double)this.histogram[n2] / (double)n);
            if (n3 > 128) {
                n3 = 128;
            }
            imageProcessor.drawLine(i + 20, 138, i + 20, 138 - n3);
        }
    }

    void drawLogPlot(int n, ImageProcessor imageProcessor) {
        this.frame = new Rectangle(20, 10, 256, 128);
        imageProcessor.drawRect(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height + 1);
        double d = Math.log(n);
        imageProcessor.setColor(Color.gray);
        for (int i = 0; i < 256; ++i) {
            int n2;
            int n3 = (int)((double)i * (double)this.histogram.length / 256.0);
            int n4 = n2 = this.histogram[n3] == 0 ? 0 : (int)(128.0 * Math.log(this.histogram[n3]) / d);
            if (n2 > 128) {
                n2 = 128;
            }
            imageProcessor.drawLine(i + 20, 138, i + 20, 138 - n2);
        }
        imageProcessor.setColor(Color.black);
    }

    void drawText(ImageProcessor imageProcessor, int n, int n2, boolean bl) {
        imageProcessor.setFont(new Font("SansSerif", 0, 12));
        imageProcessor.setAntialiasedText(true);
        double d = this.cal.getCValue(this.stats.histMin);
        double d2 = this.cal.getCValue(this.stats.histMax);
        double d3 = d2 - d;
        if (bl && !this.cal.calibrated() && d == 0.0 && d2 == 255.0) {
            d3 = 256.0;
        }
        imageProcessor.drawString(this.d2s(d), n - 4, n2);
        imageProcessor.drawString(this.d2s(d2), n + 256 - this.getWidth(d2, imageProcessor) + 10, n2);
        double d4 = d3 / (double)this.stats.nBins;
        d4 = Math.abs(d4);
        boolean bl2 = d4 != 1.0 || !bl;
        int n3 = 25;
        int n4 = 148;
        int n5 = n2 + 25;
        if (bl2) {
            n5 -= 8;
        }
        int n6 = n5 + 15;
        int n7 = n6 + 15;
        int n8 = n7 + 15;
        long l = this.stats.longPixelCount > 0L ? this.stats.longPixelCount : (long)this.stats.pixelCount;
        imageProcessor.drawString("Count: " + l, n3, n5);
        imageProcessor.drawString("Mean: " + this.d2s(this.stats.mean), n3, n6);
        imageProcessor.drawString("StdDev: " + this.d2s(this.stats.stdDev), n3, n7);
        imageProcessor.drawString("Mode: " + this.d2s(this.stats.dmode) + " (" + this.stats.maxCount + ")", n4, n7);
        imageProcessor.drawString("Min: " + this.d2s(this.stats.min), n4, n5);
        imageProcessor.drawString("Max: " + this.d2s(this.stats.max), n4, n6);
        if (bl2) {
            imageProcessor.drawString("Bins: " + this.d2s(this.stats.nBins), n3, n8);
            imageProcessor.drawString("Bin Width: " + this.d2s(d4), n4, n8);
        }
    }

    String d2s(double d) {
        if (d == Double.MAX_VALUE || d == -1.7976931348623157E308) {
            return "0";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Double.isInfinite(d)) {
            return "Infinity";
        }
        if ((double)((int)d) == d) {
            return ResultsTable.d2s(d, 0);
        }
        return ResultsTable.d2s(d, this.decimalPlaces);
    }

    int getWidth(double d, ImageProcessor imageProcessor) {
        return imageProcessor.getStringWidth(this.d2s(d));
    }

    protected void showList() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string = this.stats.binSize == 1.0 ? "value" : "bin start";
        if (this.cal.calibrated() && !this.cal.isSigned16Bit()) {
            for (int i = 0; i < this.stats.nBins; ++i) {
                stringBuffer.append(i + "\t" + ResultsTable.d2s(this.cal.getCValue(this.stats.histMin + (double)i * this.stats.binSize), this.digits) + "\t" + this.histogram[i] + "\n");
            }
            TextWindow textWindow = new TextWindow(this.getTitle(), "level\t" + string + "\tcount", stringBuffer.toString(), 200, 400);
        } else {
            for (int i = 0; i < this.stats.nBins; ++i) {
                stringBuffer.append(ResultsTable.d2s(this.cal.getCValue(this.stats.histMin + (double)i * this.stats.binSize), this.digits) + "\t" + this.histogram[i] + "\n");
            }
            TextWindow textWindow = new TextWindow(this.getTitle(), string + "\tcount", stringBuffer.toString(), 200, 400);
        }
    }

    protected void copyToClipboard() {
        Clipboard clipboard = null;
        try {
            clipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception exception) {
            clipboard = null;
        }
        if (clipboard == null) {
            IJ.error("Unable to copy to Clipboard.");
            return;
        }
        IJ.showStatus("Copying histogram values...");
        CharArrayWriter charArrayWriter = new CharArrayWriter(this.stats.nBins * 4);
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        for (int i = 0; i < this.stats.nBins; ++i) {
            printWriter.print(ResultsTable.d2s(this.cal.getCValue(this.stats.histMin + (double)i * this.stats.binSize), this.digits) + "\t" + this.histogram[i] + "\n");
        }
        String string = charArrayWriter.toString();
        printWriter.close();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, this);
        IJ.showStatus(string.length() + " characters copied to Clipboard");
    }

    void replot() {
        this.logScale = !this.logScale;
        ImageProcessor imageProcessor = this.imp.getProcessor();
        this.frame = new Rectangle(20, 10, 256, 128);
        imageProcessor.setColor(Color.white);
        imageProcessor.setRoi(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height);
        imageProcessor.fill();
        imageProcessor.resetRoi();
        imageProcessor.setColor(Color.black);
        if (this.logScale) {
            this.drawLogPlot(this.yMax > 0 ? this.yMax : this.newMaxCount, imageProcessor);
            this.drawPlot(this.yMax > 0 ? this.yMax : this.newMaxCount, imageProcessor);
        } else {
            this.drawPlot(this.yMax > 0 ? this.yMax : this.newMaxCount, imageProcessor);
        }
        this.imp.updateAndDraw();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.list) {
            this.showList();
        } else if (object == this.copy) {
            this.copyToClipboard();
        } else if (object == this.log) {
            this.replot();
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public int[] getHistogram() {
        return this.histogram;
    }

    public double[] getXValues() {
        double[] dArray = new double[this.stats.nBins];
        for (int i = 0; i < this.stats.nBins; ++i) {
            dArray[i] = this.cal.getCValue(this.stats.histMin + (double)i * this.stats.binSize);
        }
        return dArray;
    }
}

