/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.io.FileInfo;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

class FitsDecoder {
    private String directory;
    private String fileName;
    private DataInputStream f;
    private StringBuffer info = new StringBuffer(512);
    double bscale;
    double bzero;

    public FitsDecoder(String string, String string2) {
        this.directory = string;
        this.fileName = string2;
    }

    FileInfo getInfo() throws IOException {
        int n;
        FileInfo fileInfo;
        block16: {
            fileInfo = new FileInfo();
            fileInfo.fileFormat = 4;
            fileInfo.fileName = this.fileName;
            fileInfo.directory = this.directory;
            fileInfo.width = 0;
            fileInfo.height = 0;
            fileInfo.offset = 0;
            InputStream inputStream = new FileInputStream(this.directory + this.fileName);
            if (this.fileName.toLowerCase().endsWith(".gz")) {
                inputStream = new GZIPInputStream(inputStream);
            }
            this.f = new DataInputStream(inputStream);
            String string = this.getString(80);
            this.info.append(string + "\n");
            if (!string.startsWith("SIMPLE")) {
                this.f.close();
                return null;
            }
            n = 1;
            do {
                String string2;
                String string3;
                ++n;
                string = this.getString(80);
                this.info.append(string + "\n");
                int n2 = string.indexOf("=");
                int n3 = string.indexOf("/", n2);
                if (n3 < 0) {
                    n3 = string.length();
                }
                if (n2 >= 0) {
                    string3 = string.substring(0, n2).trim();
                    string2 = string.substring(n2 + 1, n3).trim();
                } else {
                    string3 = string.trim();
                    string2 = "";
                }
                if (string3.equals("END")) break block16;
                if (string3.equals("BITPIX")) {
                    int n4 = Integer.parseInt(string2);
                    if (n4 == 8) {
                        fileInfo.fileType = 0;
                        continue;
                    }
                    if (n4 == 16) {
                        fileInfo.fileType = 1;
                        continue;
                    }
                    if (n4 == 32) {
                        fileInfo.fileType = 3;
                        continue;
                    }
                    if (n4 == -32) {
                        fileInfo.fileType = 4;
                        continue;
                    }
                    if (n4 == -64) {
                        fileInfo.fileType = 16;
                        continue;
                    }
                    IJ.error("BITPIX must be 8, 16, 32, -32 (float) or -64 (double).");
                    this.f.close();
                    return null;
                }
                if (string3.equals("NAXIS1")) {
                    fileInfo.width = Integer.parseInt(string2);
                    continue;
                }
                if (string3.equals("NAXIS2")) {
                    fileInfo.height = Integer.parseInt(string2);
                    continue;
                }
                if (string3.equals("NAXIS3")) {
                    fileInfo.nImages = Integer.parseInt(string2);
                    continue;
                }
                if (string3.equals("BSCALE")) {
                    this.bscale = this.parseDouble(string2);
                    continue;
                }
                if (!string3.equals("BZERO")) continue;
                this.bzero = this.parseDouble(string2);
            } while (n <= 360 || fileInfo.width != 0);
            this.f.close();
            return null;
        }
        this.f.close();
        fileInfo.offset = 2880 + 2880 * ((n * 80 - 1) / 2880);
        return fileInfo;
    }

    String getString(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.f.readFully(byArray);
        return new String(byArray);
    }

    int getInteger(String string) {
        string = string.substring(10, 30);
        string = string.trim();
        return Integer.parseInt(string);
    }

    double parseDouble(String string) throws NumberFormatException {
        Double d = new Double(string);
        return d;
    }

    String getHeaderInfo() {
        return new String(this.info);
    }
}

