/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Rectangle;

public class GaussianBlur
implements ExtendedPlugInFilter,
DialogListener {
    private static double sigma = 2.0;
    private static boolean sigmaScaled = false;
    private int flags = 16810079;
    private ImagePlus imp;
    private boolean hasScale = false;
    private int nPasses = 1;
    private int nChannels = 1;
    private int pass;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        if (imagePlus != null && imagePlus.getRoi() != null) {
            Rectangle rectangle = imagePlus.getRoi().getBoundingRect();
            if (rectangle.y > 0 || rectangle.y + rectangle.height < imagePlus.getDimensions()[1]) {
                this.flags |= 0x4000;
            }
        }
        return this.flags;
    }

    public int showDialog(ImagePlus imagePlus, String string, PlugInFilterRunner plugInFilterRunner) {
        String string2 = Macro.getOptions();
        boolean bl = false;
        this.nChannels = imagePlus.getProcessor().getNChannels();
        if (string2 != null && string2.indexOf("radius=") >= 0) {
            bl = true;
            Macro.setOptions(string2.replaceAll("radius=", "sigma="));
        }
        GenericDialog genericDialog = new GenericDialog(string);
        sigma = Math.abs(sigma);
        genericDialog.addNumericField("Sigma (Radius)", sigma, 2);
        if (imagePlus.getCalibration() != null && !imagePlus.getCalibration().getUnits().equals("pixels")) {
            this.hasScale = true;
            genericDialog.addCheckbox("Scaled Units (" + imagePlus.getCalibration().getUnits() + ")", sigmaScaled);
        } else {
            sigmaScaled = false;
        }
        genericDialog.addPreviewCheckbox(plugInFilterRunner);
        genericDialog.addDialogListener(this);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return 4096;
        }
        if (bl) {
            sigma /= 2.5;
        }
        IJ.register(this.getClass());
        return IJ.setupDialog(imagePlus, this.flags);
    }

    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        sigma = genericDialog.getNextNumber();
        if (sigma < 0.0 || genericDialog.invalidNumber()) {
            return false;
        }
        if (this.hasScale) {
            sigmaScaled = genericDialog.getNextBoolean();
        }
        return true;
    }

    public void setNPasses(int n) {
        this.nPasses = 2 * this.nChannels * n;
        this.pass = 0;
    }

    public void run(ImageProcessor imageProcessor) {
        double d = sigmaScaled ? sigma / this.imp.getCalibration().pixelWidth : sigma;
        double d2 = sigmaScaled ? sigma / this.imp.getCalibration().pixelHeight : sigma;
        double d3 = imageProcessor instanceof ByteProcessor || imageProcessor instanceof ColorProcessor ? 0.002 : 2.0E-4;
        Rectangle rectangle = imageProcessor.getRoi();
        this.blurGaussian(imageProcessor, d, d2, d3);
    }

    public boolean blur(ImageProcessor imageProcessor, double d) {
        Rectangle rectangle = imageProcessor.getRoi();
        if (rectangle.height != imageProcessor.getHeight() && imageProcessor.getMask() == null) {
            imageProcessor.snapshot();
        }
        this.blurGaussian(imageProcessor, 0.4 * d, 0.4 * d, 0.01);
        return true;
    }

    public void blurGaussian(ImageProcessor imageProcessor, double d, double d2, double d3) {
        if (this.nPasses <= 1) {
            this.nPasses = imageProcessor.getNChannels() * (d > 0.0 && d2 > 0.0 ? 2 : 1);
        }
        FloatProcessor floatProcessor = null;
        for (int i = 0; i < imageProcessor.getNChannels(); ++i) {
            floatProcessor = imageProcessor.toFloat(i, floatProcessor);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.blurFloat(floatProcessor, d, d2, d3);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            imageProcessor.setPixels(i, floatProcessor);
        }
        if (imageProcessor.getRoi().height != imageProcessor.getHeight() && d > 0.0 && d2 > 0.0) {
            GaussianBlur.resetOutOfRoi(imageProcessor, (int)Math.ceil(5.0 * d2));
        }
    }

    public void blurFloat(FloatProcessor floatProcessor, double d, double d2, double d3) {
        if (d > 0.0) {
            this.blur1Direction(floatProcessor, d, d3, true, (int)Math.ceil(5.0 * d2));
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (d2 > 0.0) {
            this.blur1Direction(floatProcessor, d2, d3, false, 0);
        }
    }

    public void blur1Direction(FloatProcessor floatProcessor, double d, double d2, boolean bl, int n) {
        int n2;
        float[] fArray = (float[])floatProcessor.getPixels();
        int n3 = floatProcessor.getWidth();
        int n4 = floatProcessor.getHeight();
        Rectangle rectangle = floatProcessor.getRoi();
        int n5 = bl ? n3 : n4;
        int n6 = bl ? 1 : n3;
        int n7 = bl ? n3 : 1;
        int n8 = (bl ? rectangle.y : rectangle.x) - n;
        if (n8 < 0) {
            n8 = 0;
        }
        if ((n2 = (bl ? rectangle.y + rectangle.height : rectangle.x + rectangle.width) + n) > (bl ? n4 : n3)) {
            n2 = bl ? n4 : n3;
        }
        int n9 = bl ? rectangle.x : rectangle.y;
        int n10 = bl ? rectangle.x + rectangle.width : rectangle.y + rectangle.height;
        int n11 = Math.max((n2 - n8) / (100 / (this.nPasses > 0 ? this.nPasses : 1) + 1), 20);
        ++this.pass;
        if (this.pass > this.nPasses) {
            this.pass = 1;
        }
        Thread thread = Thread.currentThread();
        if (d > 8.5) {
            int n12;
            double d3;
            float[][] fArray2;
            int n13;
            int n14 = (int)Math.floor(d / 4.0);
            if (n14 > n5) {
                n14 = n5;
            }
            int n15 = n9 - (n13 = (fArray2 = this.makeGaussianKernel(d3 = Math.sqrt(d * d / (double)(n14 * n14) - 0.3333333333333333 - 0.25), d2, n12 = (n5 + n14 - 1) / n14 + 6))[0].length * n14) < 0 ? 0 : n9 - n13;
            int n16 = n10 + n13 > n5 ? n5 : n10 + n13;
            int n17 = (n16 - n15 + n14 - 1) / n14 + 6;
            int n18 = n15 - 3 * n14;
            float[] fArray3 = this.makeDownscaleKernel(n14);
            float[] fArray4 = this.makeUpscaleKernel(n14);
            float[] fArray5 = new float[n17];
            float[] fArray6 = new float[n17];
            int n19 = n8 * n7;
            int n20 = n8;
            while (n20 < n2) {
                if (n20 % n11 == 0) {
                    this.showProgress((double)(n20 - n8) / (double)(n2 - n8));
                    if (thread.isInterrupted()) {
                        return;
                    }
                }
                this.downscaleLine(fArray, fArray5, fArray3, n14, n19, n18, n5, n6, n17);
                this.convolveLine(fArray5, fArray6, fArray2, 0, n17, 1, n17 - 1, 0, 1);
                this.upscaleLine(fArray6, fArray, fArray4, n14, n19, n18, n9, n10, n6);
                ++n20;
                n19 += n7;
            }
        } else {
            float[][] fArray7 = this.makeGaussianKernel(d, d2, n5);
            int n21 = fArray7[0].length;
            float[] fArray8 = new float[n5];
            int n22 = n9 - n21 < 0 ? 0 : n9 - n21;
            int n23 = n10 + n21 > n5 ? n5 : n10 + n21;
            int n24 = n8 * n7;
            int n25 = n8;
            while (n25 < n2) {
                if (n25 % n11 == 0) {
                    this.showProgress((double)(n25 - n8) / (double)(n2 - n8));
                    if (thread.isInterrupted()) {
                        return;
                    }
                }
                int n26 = n24 + n22 * n6;
                int n27 = n22;
                while (n27 < n23) {
                    fArray8[n27] = fArray[n26];
                    ++n27;
                    n26 += n6;
                }
                this.convolveLine(fArray8, fArray, fArray7, n22, n23, n9, n10, n24, n6);
                ++n25;
                n24 += n7;
            }
        }
        this.showProgress(1.0);
    }

    void downscaleLine(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, int n3, int n4, int n5, int n6) {
        float f = fArray[n2];
        float f2 = fArray[n2 + n5 * (n4 - 1)];
        int n7 = n3 - n / 2;
        int n8 = n2 + n5 * n7;
        for (int i = 0; i < n6; ++i) {
            float f3 = 0.0f;
            int n9 = 0;
            while (n9 < n) {
                f3 += fArray3[n9] * (n7 - n < 0 ? f : (n7 - n >= n4 ? f2 : fArray[n8 - n5 * n]));
                f3 += fArray3[n9 + n] * (n7 < 0 ? f : (n7 >= n4 ? f2 : fArray[n8]));
                f3 += fArray3[n9 + 2 * n] * (n7 + n < 0 ? f : (n7 + n >= n4 ? f2 : fArray[n8 + n5 * n]));
                ++n9;
                ++n7;
                n8 += n5;
            }
            fArray2[i] = f3;
        }
    }

    float[] makeDownscaleKernel(int n) {
        float f;
        double d;
        int n2;
        int n3 = n * 3 / 2;
        float[] fArray = new float[3 * n];
        for (n2 = 0; n2 <= n / 2; ++n2) {
            d = (double)n2 / (double)n;
            fArray[n3 - n2] = f = (float)((0.75 - d * d) / (double)n);
            fArray[n3 + n2] = f;
        }
        for (n2 = n / 2 + 1; n2 < (n * 3 + 1) / 2; ++n2) {
            d = (double)n2 / (double)n;
            fArray[n3 - n2] = f = (float)((0.125 + 0.5 * (d - 1.0) * (d - 2.0)) / (double)n);
            fArray[n3 + n2] = f;
        }
        return fArray;
    }

    void upscaleLine(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n2 + n6 * n4;
        int n8 = n4;
        while (n8 < n5) {
            int n9 = (n8 - n3 + n - 1) / n;
            int n10 = n - 1 - (n8 - n3 + n - 1) % n;
            fArray2[n7] = fArray[n9 - 2] * fArray3[n10] + fArray[n9 - 1] * fArray3[n10 + n] + fArray[n9] * fArray3[n10 + 2 * n] + fArray[n9 + 1] * fArray3[n10 + 3 * n];
            ++n8;
            n7 += n6;
        }
    }

    float[] makeUpscaleKernel(int n) {
        float f;
        double d;
        int n2;
        float[] fArray = new float[4 * n];
        int n3 = 2 * n;
        fArray[0] = 0.0f;
        for (n2 = 0; n2 < n; ++n2) {
            d = (double)n2 / (double)n;
            fArray[n3 + n2] = f = (float)(0.6666666666666666 - d * d * (1.0 - 0.5 * d));
            fArray[n3 - n2] = f;
        }
        for (n2 = n; n2 < 2 * n; ++n2) {
            d = (double)n2 / (double)n;
            fArray[n3 + n2] = f = (float)((2.0 - d) * (2.0 - d) * (2.0 - d) / 6.0);
            fArray[n3 - n2] = f;
        }
        return fArray;
    }

    public void convolveLine(float[] fArray, float[] fArray2, float[][] fArray3, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = fArray.length;
        float f = fArray[0];
        float f2 = fArray[n8 - 1];
        float[] fArray4 = fArray3[0];
        float f3 = fArray4[0];
        float[] fArray5 = fArray3[1];
        int n9 = fArray4.length;
        int n10 = n9 < n8 ? n9 : n8;
        int n11 = n5 + n3 * n6;
        int n12 = n3;
        while (n12 < n10) {
            float f4 = fArray[n12] * f3;
            f4 += fArray5[n12] * f;
            if (n12 + n9 > n8) {
                f4 += fArray5[n8 - n12 - 1] * f2;
            }
            for (int i = 1; i < n9; ++i) {
                float f5 = 0.0f;
                if (n12 - i >= 0) {
                    f5 += fArray[n12 - i];
                }
                if (n12 + i < n8) {
                    f5 += fArray[n12 + i];
                }
                f4 += fArray4[i] * f5;
            }
            fArray2[n11] = f4;
            ++n12;
            n11 += n6;
        }
        int n13 = n7 = n8 - n9 < n4 ? n8 - n9 : n4;
        while (n12 < n7) {
            float f6 = fArray[n12] * f3;
            for (int i = 1; i < n9; ++i) {
                f6 += fArray4[i] * (fArray[n12 - i] + fArray[n12 + i]);
            }
            fArray2[n11] = f6;
            ++n12;
            n11 += n6;
        }
        while (n12 < n4) {
            float f7 = fArray[n12] * f3;
            if (n12 < n9) {
                f7 += fArray5[n12] * f;
            }
            if (n12 + n9 >= n8) {
                f7 += fArray5[n8 - n12 - 1] * f2;
            }
            for (int i = 1; i < n9; ++i) {
                float f8 = 0.0f;
                if (n12 - i >= 0) {
                    f8 += fArray[n12 - i];
                }
                if (n12 + i < n8) {
                    f8 += fArray[n12 + i];
                }
                f7 += fArray4[i] * f8;
            }
            fArray2[n11] = f7;
            ++n12;
            n11 += n6;
        }
    }

    public float[][] makeGaussianKernel(double d, double d2, int n) {
        double d3;
        int n2;
        int n3 = (int)Math.ceil(d * Math.sqrt(-2.0 * Math.log(d2))) + 1;
        if (n < 50) {
            n = 50;
        }
        if (n3 > n) {
            n3 = n;
        }
        float[][] fArray = new float[2][n3];
        for (int i = 0; i < n3; ++i) {
            fArray[0][i] = (float)Math.exp(-0.5 * (double)i * (double)i / d / d);
        }
        if (n3 < n && n3 > 3) {
            double d4;
            double d5 = Double.MAX_VALUE;
            n2 = n3;
            while (n2 > n3 / 2 && (d4 = Math.sqrt(fArray[0][--n2]) / (double)(n3 - n2)) < d5) {
                d5 = d4;
            }
            for (int i = n2 + 2; i < n3; ++i) {
                fArray[0][i] = (float)((double)((n3 - i) * (n3 - i)) * d5 * d5);
            }
        }
        if (n3 < n) {
            d3 = fArray[0][0];
            for (n2 = 1; n2 < n3; ++n2) {
                d3 += (double)(2.0f * fArray[0][n2]);
            }
        } else {
            d3 = d * Math.sqrt(Math.PI * 2);
        }
        double d6 = 0.5 + 0.5 * (double)fArray[0][0] / d3;
        for (int i = 0; i < n3; ++i) {
            double d7 = (double)fArray[0][i] / d3;
            fArray[0][i] = (float)d7;
            fArray[1][i] = (float)(d6 -= d7);
        }
        return fArray;
    }

    public static void resetOutOfRoi(ImageProcessor imageProcessor, int n) {
        Rectangle rectangle = imageProcessor.getRoi();
        int n2 = imageProcessor.getWidth();
        int n3 = imageProcessor.getHeight();
        Object object = imageProcessor.getPixels();
        Object object2 = imageProcessor.getSnapshotPixels();
        int n4 = rectangle.y - n;
        if (n4 < 0) {
            n4 = 0;
        }
        int n5 = n4;
        int n6 = n2 * n5 + rectangle.x;
        while (n5 < rectangle.y) {
            System.arraycopy(object2, n6, object, n6, rectangle.width);
            ++n5;
            n6 += n2;
        }
        n5 = rectangle.y + rectangle.height + n;
        if (n5 > n3) {
            n5 = n3;
        }
        n6 = rectangle.y + rectangle.height;
        int n7 = n2 * n6 + rectangle.x;
        while (n6 < n5) {
            System.arraycopy(object2, n7, object, n7, rectangle.width);
            ++n6;
            n7 += n2;
        }
    }

    void showProgress(double d) {
        d = (double)(this.pass - 1) / (double)this.nPasses + d / (double)this.nPasses;
        IJ.showProgress(d);
    }
}

