/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.io.RoiEncoder;
import ij.io.SaveDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.io.IOException;

public class RoiWriter
implements PlugInFilter {
    ImagePlus imp;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 1183;
    }

    public void run(ImageProcessor imageProcessor) {
        try {
            this.saveRoi(this.imp);
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if (string == null || string.equals("")) {
                string = "" + iOException;
            }
            IJ.error("ROI Writer", string);
        }
    }

    public void saveRoi(ImagePlus imagePlus) throws IOException {
        SaveDialog saveDialog;
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            throw new IllegalArgumentException("ROI required");
        }
        String string = roi.getName();
        if (string == null) {
            string = imagePlus.getTitle();
        }
        if ((string = (saveDialog = new SaveDialog("Save Selection...", string, ".roi")).getFileName()) == null) {
            return;
        }
        String string2 = saveDialog.getDirectory();
        RoiEncoder roiEncoder = new RoiEncoder(string2 + string);
        roiEncoder.write(roi);
        if (string.endsWith(".roi")) {
            string = string.substring(0, string.length() - 4);
        }
        roi.setName(string);
    }
}

