/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.process.ImageStatistics;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class ContrastPlot
extends Canvas
implements MouseListener {
    static final int WIDTH = 128;
    static final int HEIGHT = 64;
    double defaultMin = 0.0;
    double defaultMax = 255.0;
    double min = 0.0;
    double max = 255.0;
    int[] histogram;
    int hmax;
    Image os;
    Graphics osg;
    Color color = Color.gray;

    public ContrastPlot() {
        this.addMouseListener(this);
        this.setSize(129, 65);
    }

    public Dimension getPreferredSize() {
        return new Dimension(129, 65);
    }

    void setHistogram(ImageStatistics imageStatistics, Color color) {
        int n;
        int n2;
        this.color = color;
        this.histogram = imageStatistics.histogram;
        if (this.histogram.length != 256) {
            this.histogram = null;
            return;
        }
        for (n2 = 0; n2 < 128; ++n2) {
            this.histogram[n2] = (this.histogram[2 * n2] + this.histogram[2 * n2 + 1]) / 2;
        }
        n2 = 0;
        int n3 = 0;
        for (n = 0; n < 128; ++n) {
            if (this.histogram[n] <= n2) continue;
            n2 = this.histogram[n];
            n3 = n;
        }
        n = 0;
        for (int i = 0; i < 128; ++i) {
            if (this.histogram[i] <= n || i == n3) continue;
            n = this.histogram[i];
        }
        this.hmax = imageStatistics.maxCount;
        if (this.hmax > n * 2 && n != 0) {
            this.histogram[n3] = this.hmax = (int)((double)n * 1.5);
        }
        this.os = null;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        double d = 128.0 / (this.defaultMax - this.defaultMin);
        double d2 = 0.0;
        if (this.max != this.min) {
            d2 = 64.0 / (this.max - this.min);
        }
        if (this.min >= this.defaultMin) {
            n4 = (int)(d * (this.min - this.defaultMin));
            n3 = 64;
        } else {
            n4 = 0;
            n3 = this.max > this.min ? 64 - (int)((this.defaultMin - this.min) * d2) : 64;
        }
        if (this.max <= this.defaultMax) {
            n2 = (int)(d * (this.max - this.defaultMin));
            n = 0;
        } else {
            n2 = 128;
            n = this.max > this.min ? 64 - (int)((this.defaultMax - this.min) * d2) : 0;
        }
        if (this.histogram != null) {
            if (this.os == null && this.hmax != 0) {
                this.os = this.createImage(128, 64);
                this.osg = this.os.getGraphics();
                this.osg.setColor(Color.white);
                this.osg.fillRect(0, 0, 128, 64);
                this.osg.setColor(this.color);
                for (int i = 0; i < 128; ++i) {
                    this.osg.drawLine(i, 64, i, 64 - 64 * this.histogram[i] / this.hmax);
                }
                this.osg.dispose();
            }
            if (this.os != null) {
                graphics.drawImage(this.os, 0, 0, this);
            }
        } else {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, 128, 64);
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n4, n3, n2, n);
        graphics.drawLine(n2, 59, n2, 64);
        graphics.drawRect(0, 0, 128, 64);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }
}

