/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.TrimmedButton;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.plugin.frame.PasteController;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.ThresholdPlot;
import ij.process.AutoThresholder;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;

public class ThresholdAdjuster
extends PlugInFrame
implements PlugIn,
Measurements,
Runnable,
ActionListener,
AdjustmentListener,
ItemListener {
    public static final String LOC_KEY = "threshold.loc";
    public static final String MODE_KEY = "threshold.mode";
    public static final String DARK_BACKGROUND = "threshold.dark";
    static final int RED = 0;
    static final int BLACK_AND_WHITE = 1;
    static final int OVER_UNDER = 2;
    static final String[] modes = new String[]{"Red", "B&W", "Over/Under"};
    static final double defaultMinThreshold = 85.0;
    static final double defaultMaxThreshold = 170.0;
    static final int DEFAULT = 0;
    static boolean fill1 = true;
    static boolean fill2 = true;
    static boolean useBW = true;
    static boolean backgroundToNaN = true;
    static Frame instance;
    static int mode;
    static String[] methodNames;
    static String method;
    static AutoThresholder thresholder;
    ThresholdPlot plot = new ThresholdPlot();
    Thread thread;
    int minValue = -1;
    int maxValue = -1;
    int sliderRange = 256;
    boolean doAutoAdjust;
    boolean doReset;
    boolean doApplyLut;
    boolean doStateChange;
    boolean doSet;
    Panel panel;
    Button autoB;
    Button resetB;
    Button applyB;
    Button setB;
    int previousImageID;
    int previousImageType;
    double previousMin;
    double previousMax;
    int previousSlice;
    ImageJ ij;
    double minThreshold;
    double maxThreshold;
    Scrollbar minSlider;
    Scrollbar maxSlider;
    Label label1;
    Label label2;
    boolean done;
    boolean invertedLut;
    int lutColor;
    Choice methodChoice;
    Choice modeChoice;
    Checkbox darkBackground;
    boolean firstActivation;
    boolean useExistingTheshold;
    static final int RESET = 0;
    static final int AUTO = 1;
    static final int HIST = 2;
    static final int APPLY = 3;
    static final int STATE_CHANGE = 4;
    static final int MIN_THRESHOLD = 5;
    static final int MAX_THRESHOLD = 6;
    static final int SET = 7;

    public ThresholdAdjuster() {
        super("Threshold");
        int n;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null && imagePlus.getBitDepth() == 24) {
            IJ.run(imagePlus, "Color Threshold...", "");
            return;
        }
        if (instance != null) {
            instance.toFront();
            return;
        }
        WindowManager.addWindow(this);
        instance = this;
        mode = (int)Prefs.get(MODE_KEY, 0.0);
        if (mode < 0 || mode > 2) {
            mode = 0;
        }
        this.setLutColor(mode);
        IJ.register(PasteController.class);
        this.ij = IJ.getInstance();
        Font font = new Font("SansSerif", 0, 10);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        int n2 = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.plot, gridBagConstraints);
        this.plot.addKeyListener(this.ij);
        this.minSlider = new Scrollbar(0, this.sliderRange / 3, 1, 0, this.sliderRange);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = IJ.isMacintosh() ? 90.0 : 100.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add((Component)this.minSlider, gridBagConstraints);
        this.minSlider.addAdjustmentListener(this);
        this.minSlider.addKeyListener(this.ij);
        this.minSlider.setUnitIncrement(1);
        this.minSlider.setFocusable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = IJ.isMacintosh() ? 10.0 : 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.label1 = new Label("       ", 2);
        this.label1.setFont(font);
        this.add((Component)this.label1, gridBagConstraints);
        this.maxSlider = new Scrollbar(0, this.sliderRange * 2 / 3, 1, 0, this.sliderRange);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.maxSlider, gridBagConstraints);
        this.maxSlider.addAdjustmentListener(this);
        this.maxSlider.addKeyListener(this.ij);
        this.maxSlider.setUnitIncrement(1);
        this.maxSlider.setFocusable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.label2 = new Label("       ", 2);
        this.label2.setFont(font);
        this.add((Component)this.label2, gridBagConstraints);
        this.panel = new Panel();
        this.methodChoice = new Choice();
        for (n = 0; n < methodNames.length; n += 1) {
            this.methodChoice.addItem(methodNames[n]);
        }
        this.methodChoice.select(method);
        this.methodChoice.addItemListener(this);
        this.panel.add(this.methodChoice);
        this.modeChoice = new Choice();
        for (n = 0; n < modes.length; n += 1) {
            this.modeChoice.addItem(modes[n]);
        }
        this.modeChoice.select(mode);
        this.modeChoice.addItemListener(this);
        this.panel.add(this.modeChoice);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        this.add((Component)this.panel, gridBagConstraints);
        n = Prefs.get(DARK_BACKGROUND, Prefs.blackBackground) ? 1 : 0;
        this.darkBackground = new Checkbox("Dark background");
        this.darkBackground.setState(n != 0);
        this.darkBackground.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 35, 0, 5);
        this.add((Component)this.darkBackground, gridBagConstraints);
        int n3 = IJ.isMacOSX() ? 11 : 0;
        this.panel = new Panel();
        this.autoB = new TrimmedButton("Auto", n3);
        this.autoB.addActionListener(this);
        this.autoB.addKeyListener(this.ij);
        this.panel.add(this.autoB);
        this.applyB = new TrimmedButton("Apply", n3);
        this.applyB.addActionListener(this);
        this.applyB.addKeyListener(this.ij);
        this.panel.add(this.applyB);
        this.resetB = new TrimmedButton("Reset", n3);
        this.resetB.addActionListener(this);
        this.resetB.addKeyListener(this.ij);
        this.panel.add(this.resetB);
        this.setB = new TrimmedButton("Set", n3);
        this.setB.addActionListener(this);
        this.setB.addKeyListener(this.ij);
        this.panel.add(this.setB);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 5, 10, 5);
        this.add((Component)this.panel, gridBagConstraints);
        this.addKeyListener(this.ij);
        this.pack();
        Point point = Prefs.getLocation(LOC_KEY);
        if (point != null) {
            this.setLocation(point);
        } else {
            GUI.center(this);
        }
        this.firstActivation = true;
        if (IJ.isMacOSX()) {
            this.setResizable(false);
        }
        this.show();
        this.thread = new Thread((Runnable)this, "ThresholdAdjuster");
        this.thread.start();
        ImagePlus imagePlus2 = WindowManager.getCurrentImage();
        if (imagePlus2 != null) {
            this.useExistingTheshold = this.isThresholded(imagePlus2);
            this.setup(imagePlus2);
        }
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.minSlider) {
            this.minValue = this.minSlider.getValue();
        } else {
            this.maxValue = this.maxSlider.getValue();
        }
        this.notify();
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        Button button = (Button)actionEvent.getSource();
        if (button == null) {
            return;
        }
        if (button == this.resetB) {
            this.doReset = true;
        } else if (button == this.autoB) {
            this.doAutoAdjust = true;
        } else if (button == this.applyB) {
            this.doApplyLut = true;
        } else if (button == this.setB) {
            this.doSet = true;
        }
        this.notify();
    }

    void setLutColor(int n) {
        switch (n) {
            case 0: {
                this.lutColor = 0;
                break;
            }
            case 1: {
                this.lutColor = 1;
                break;
            }
            case 2: {
                this.lutColor = 3;
            }
        }
    }

    public synchronized void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.methodChoice) {
            method = this.methodChoice.getSelectedItem();
            this.doAutoAdjust = true;
        } else if (object == this.modeChoice) {
            mode = this.modeChoice.getSelectedIndex();
            this.setLutColor(mode);
            this.doStateChange = true;
        } else {
            this.doAutoAdjust = true;
        }
        this.notify();
    }

    ImageProcessor setup(ImagePlus imagePlus) {
        int n = imagePlus.getType();
        if (n == 4 || imagePlus.isComposite() && ((CompositeImage)imagePlus).getMode() == 1) {
            return null;
        }
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        boolean bl = false;
        boolean bl2 = n == 1 || n == 2;
        int n2 = imagePlus.getCurrentSlice();
        if (bl2) {
            if (imageProcessor.getMin() == this.plot.stackMin && imageProcessor.getMax() == this.plot.stackMax) {
                bl = false;
            } else if (imageProcessor.getMin() != this.previousMin || imageProcessor.getMax() != this.previousMax) {
                bl = true;
                this.previousMin = imageProcessor.getMin();
                this.previousMax = imageProcessor.getMax();
            } else if (n2 != this.previousSlice) {
                bl = true;
            }
        }
        int n3 = imagePlus.getID();
        if (bl || n3 != this.previousImageID || n != this.previousImageType) {
            if (bl2 && bl && !this.useExistingTheshold) {
                imageProcessor.resetMinAndMax();
                imagePlus.updateAndDraw();
            }
            this.useExistingTheshold = false;
            this.invertedLut = imagePlus.isInvertedLut();
            this.minThreshold = imageProcessor.getMinThreshold();
            this.maxThreshold = imageProcessor.getMaxThreshold();
            ImageStatistics imageStatistics = this.plot.setHistogram(imagePlus, false);
            if (this.minThreshold == -808080.0) {
                this.autoSetLevels(imageProcessor, imageStatistics);
            } else {
                this.minThreshold = this.scaleDown(imageProcessor, this.minThreshold);
                this.maxThreshold = this.scaleDown(imageProcessor, this.maxThreshold);
            }
            this.scaleUpAndSet(imageProcessor, this.minThreshold, this.maxThreshold);
            this.updateLabels(imagePlus, imageProcessor);
            this.updatePlot();
            this.updateScrollBars();
            imagePlus.updateAndDraw();
        }
        this.previousImageID = n3;
        this.previousImageType = n;
        this.previousSlice = n2;
        return imageProcessor;
    }

    void autoSetLevels(ImageProcessor imageProcessor, ImageStatistics imageStatistics) {
        if (imageStatistics == null || imageStatistics.histogram == null) {
            this.minThreshold = 85.0;
            this.maxThreshold = 170.0;
            return;
        }
        boolean bl = this.darkBackground != null && this.darkBackground.getState();
        int n = imageStatistics.histogram[imageStatistics.mode];
        if (!method.equals(methodNames[0])) {
            imageStatistics.histogram[imageStatistics.mode] = this.plot.originalModeCount;
        }
        int n2 = thresholder.getThreshold(method, imageStatistics.histogram);
        imageStatistics.histogram[imageStatistics.mode] = n;
        if (bl) {
            if (this.invertedLut) {
                this.minThreshold = 0.0;
                this.maxThreshold = n2;
            } else {
                this.minThreshold = n2 + 1;
                this.maxThreshold = 255.0;
            }
        } else if (this.invertedLut) {
            this.minThreshold = n2 + 1;
            this.maxThreshold = 255.0;
        } else {
            this.minThreshold = 0.0;
            this.maxThreshold = n2;
        }
        if (this.minThreshold > 255.0) {
            this.minThreshold = 255.0;
        }
        if (Recorder.record) {
            if (Recorder.scriptMode()) {
                Recorder.recordCall("IJ.setAutoThreshold(imp, \"" + method + (bl ? " dark" : "") + "\");");
            } else {
                Recorder.record("setAutoThreshold", method + (bl ? " dark" : ""));
            }
        }
    }

    void scaleUpAndSet(ImageProcessor imageProcessor, double d, double d2) {
        if (!(imageProcessor instanceof ByteProcessor) && d != -808080.0) {
            double d3 = imageProcessor.getMin();
            double d4 = imageProcessor.getMax();
            if (d4 > d3) {
                d = d3 + d / 255.0 * (d4 - d3);
                d2 = d3 + d2 / 255.0 * (d4 - d3);
            } else {
                d = d2 = d3;
            }
        }
        imageProcessor.setThreshold(d, d2, this.lutColor);
    }

    double scaleDown(ImageProcessor imageProcessor, double d) {
        if (imageProcessor instanceof ByteProcessor) {
            return d;
        }
        double d2 = imageProcessor.getMin();
        double d3 = imageProcessor.getMax();
        if (d3 > d2) {
            return (d - d2) / (d3 - d2) * 255.0;
        }
        return -808080.0;
    }

    double scaleUp(ImageProcessor imageProcessor, double d) {
        double d2 = imageProcessor.getMin();
        double d3 = imageProcessor.getMax();
        if (d3 > d2) {
            return d2 + d / 255.0 * (d3 - d2);
        }
        return -808080.0;
    }

    void updatePlot() {
        this.plot.minThreshold = this.minThreshold;
        this.plot.maxThreshold = this.maxThreshold;
        this.plot.mode = mode;
        this.plot.repaint();
    }

    void updateLabels(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        double d = imageProcessor.getMinThreshold();
        double d2 = imageProcessor.getMaxThreshold();
        if (d == -808080.0) {
            this.label1.setText("");
            this.label2.setText("");
        } else {
            Calibration calibration = imagePlus.getCalibration();
            if (calibration.calibrated()) {
                d = calibration.getCValue((int)d);
                d2 = calibration.getCValue((int)d2);
            }
            if ((double)((int)d) == d && (double)((int)d2) == d2 || imageProcessor instanceof ShortProcessor) {
                this.label1.setText("" + (int)d);
                this.label2.setText("" + (int)d2);
            } else {
                this.label1.setText("" + IJ.d2s(d, 2));
                this.label2.setText("" + IJ.d2s(d2, 2));
            }
        }
    }

    void updateScrollBars() {
        this.minSlider.setValue((int)this.minThreshold);
        this.maxSlider.setValue((int)this.maxThreshold);
    }

    void doMasking(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        ImageProcessor imageProcessor2 = imagePlus.getMask();
        if (imageProcessor2 != null) {
            imageProcessor.reset(imageProcessor2);
        }
    }

    void adjustMinThreshold(ImagePlus imagePlus, ImageProcessor imageProcessor, double d) {
        if (IJ.altKeyDown() || IJ.shiftKeyDown()) {
            double d2 = this.maxThreshold - this.minThreshold;
            if (d2 < 1.0) {
                d2 = 1.0;
            }
            this.minThreshold = d;
            this.maxThreshold = this.minThreshold + d2;
            if (this.minThreshold + d2 > 255.0) {
                this.minThreshold = 255.0 - d2;
                this.maxThreshold = this.minThreshold + d2;
                this.minSlider.setValue((int)this.minThreshold);
            }
            this.maxSlider.setValue((int)this.maxThreshold);
            this.scaleUpAndSet(imageProcessor, this.minThreshold, this.maxThreshold);
            return;
        }
        this.minThreshold = d;
        if (this.maxThreshold < this.minThreshold) {
            this.maxThreshold = this.minThreshold;
            this.maxSlider.setValue((int)this.maxThreshold);
        }
        this.scaleUpAndSet(imageProcessor, this.minThreshold, this.maxThreshold);
    }

    void adjustMaxThreshold(ImagePlus imagePlus, ImageProcessor imageProcessor, int n) {
        this.maxThreshold = n;
        if (this.minThreshold > this.maxThreshold) {
            this.minThreshold = this.maxThreshold;
            this.minSlider.setValue((int)this.minThreshold);
        }
        this.scaleUpAndSet(imageProcessor, this.minThreshold, this.maxThreshold);
        IJ.setKeyUp(18);
        IJ.setKeyUp(16);
    }

    void reset(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        boolean bl = false;
        if (!(imageProcessor instanceof ByteProcessor)) {
            imageProcessor.resetMinAndMax();
            bl = imagePlus.getStackSize() > 1 && IJ.altKeyDown();
        }
        imageProcessor.resetThreshold();
        this.plot.setHistogram(imagePlus, bl);
        this.updateScrollBars();
        if (Recorder.record) {
            if (Recorder.scriptMode()) {
                Recorder.recordCall("IJ.resetThreshold(imp);");
            } else {
                Recorder.record("resetThreshold");
            }
        }
    }

    void doSet(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        double d = imageProcessor.getMinThreshold();
        double d2 = imageProcessor.getMaxThreshold();
        if (d == -808080.0) {
            d = this.scaleUp(imageProcessor, 85.0);
            d2 = this.scaleUp(imageProcessor, 170.0);
        }
        Calibration calibration = imagePlus.getCalibration();
        int n = imageProcessor instanceof FloatProcessor || calibration.calibrated() ? 2 : 0;
        d = calibration.getCValue(d);
        d2 = calibration.getCValue(d2);
        GenericDialog genericDialog = new GenericDialog("Set Threshold Levels");
        genericDialog.addNumericField("Lower Threshold Level: ", d, n);
        genericDialog.addNumericField("Upper Threshold Level: ", d2, n);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        d = genericDialog.getNextNumber();
        d2 = genericDialog.getNextNumber();
        d = calibration.getRawValue(d);
        if ((d2 = calibration.getRawValue(d2)) < d) {
            d2 = d;
        }
        double d3 = imageProcessor.getMin();
        double d4 = imageProcessor.getMax();
        imageProcessor.resetMinAndMax();
        double d5 = imageProcessor.getMin();
        double d6 = imageProcessor.getMax();
        if (d < d5) {
            d = d5;
        }
        if (d2 > d6) {
            d2 = d6;
        }
        IJ.wait(500);
        imageProcessor.setThreshold(d, d2, this.lutColor);
        this.setup(imagePlus);
        if (Recorder.record) {
            if (imagePlus.getBitDepth() == 32) {
                if (Recorder.scriptMode()) {
                    Recorder.recordCall("IJ.setThreshold(" + imageProcessor.getMinThreshold() + ", " + imageProcessor.getMaxThreshold() + ");");
                } else {
                    Recorder.record("setThreshold", imageProcessor.getMinThreshold(), imageProcessor.getMaxThreshold());
                }
            } else {
                int n2 = (int)imageProcessor.getMinThreshold();
                int n3 = (int)imageProcessor.getMaxThreshold();
                if (calibration.isSigned16Bit()) {
                    n2 = (int)calibration.getCValue(d);
                    n3 = (int)calibration.getCValue(d2);
                }
                if (Recorder.scriptMode()) {
                    Recorder.recordCall("IJ.setThreshold(imp, " + n2 + ", " + n3 + ");");
                } else {
                    Recorder.record("setThreshold", n2, n3);
                }
            }
        }
    }

    void changeState(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        this.scaleUpAndSet(imageProcessor, this.minThreshold, this.maxThreshold);
        this.updateScrollBars();
    }

    void autoThreshold(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        imageProcessor.resetThreshold();
        this.previousImageID = 0;
        this.setup(imagePlus);
    }

    void apply(ImagePlus imagePlus) {
        try {
            if (imagePlus.getBitDepth() == 32) {
                GenericDialog genericDialog = new GenericDialog("NaN Backround");
                genericDialog.addCheckbox("Set Background Pixels to NaN", backgroundToNaN);
                genericDialog.showDialog();
                if (genericDialog.wasCanceled()) {
                    this.runThresholdCommand();
                    return;
                }
                backgroundToNaN = genericDialog.getNextBoolean();
                if (backgroundToNaN) {
                    Recorder.recordInMacros = true;
                    IJ.run("NaN Background");
                    Recorder.recordInMacros = false;
                } else {
                    this.runThresholdCommand();
                }
            } else {
                this.runThresholdCommand();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void runThresholdCommand() {
        Recorder.recordInMacros = true;
        IJ.run("Convert to Mask");
        Recorder.recordInMacros = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            ThresholdAdjuster thresholdAdjuster = this;
            synchronized (thresholdAdjuster) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.doUpdate();
        }
    }

    void doUpdate() {
        int n;
        int n2 = this.minValue;
        int n3 = this.maxValue;
        if (this.doReset) {
            n = 0;
        } else if (this.doAutoAdjust) {
            n = 1;
        } else if (this.doApplyLut) {
            n = 3;
        } else if (this.doStateChange) {
            n = 4;
        } else if (this.doSet) {
            n = 7;
        } else if (this.minValue >= 0) {
            n = 5;
        } else if (this.maxValue >= 0) {
            n = 6;
        } else {
            return;
        }
        this.minValue = -1;
        this.maxValue = -1;
        this.doReset = false;
        this.doAutoAdjust = false;
        this.doApplyLut = false;
        this.doStateChange = false;
        this.doSet = false;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.beep();
            IJ.showStatus("No image");
            return;
        }
        ImageProcessor imageProcessor = this.setup(imagePlus);
        if (imageProcessor == null) {
            imagePlus.unlock();
            IJ.beep();
            if (imagePlus.isComposite()) {
                IJ.showStatus("\"Composite\" mode images cannot be thresholded");
            } else {
                IJ.showStatus("RGB images cannot be thresholded");
            }
            return;
        }
        switch (n) {
            case 0: {
                this.reset(imagePlus, imageProcessor);
                break;
            }
            case 1: {
                this.autoThreshold(imagePlus, imageProcessor);
                break;
            }
            case 3: {
                this.apply(imagePlus);
                break;
            }
            case 4: {
                this.changeState(imagePlus, imageProcessor);
                break;
            }
            case 7: {
                this.doSet(imagePlus, imageProcessor);
                break;
            }
            case 5: {
                this.adjustMinThreshold(imagePlus, imageProcessor, n2);
                break;
            }
            case 6: {
                this.adjustMaxThreshold(imagePlus, imageProcessor, n3);
            }
        }
        this.updatePlot();
        this.updateLabels(imagePlus, imageProcessor);
        imageProcessor.setLutAnimation(true);
        imagePlus.updateAndDraw();
    }

    public void windowClosing(WindowEvent windowEvent) {
        Prefs.saveLocation(LOC_KEY, this.getLocation());
        Prefs.set(MODE_KEY, mode);
        Prefs.set(DARK_BACKGROUND, this.darkBackground.getState());
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        instance = null;
        this.done = true;
        ThresholdAdjuster thresholdAdjuster = this;
        synchronized (thresholdAdjuster) {
            this.notify();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
        super.windowActivated(windowEvent);
        this.plot.requestFocus();
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            if (!this.firstActivation) {
                this.previousImageID = 0;
                this.useExistingTheshold = this.isThresholded(imagePlus);
                this.setup(imagePlus);
            }
            this.firstActivation = false;
        }
    }

    boolean isThresholded(ImagePlus imagePlus) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        return imageProcessor.getMinThreshold() != -808080.0 && imageProcessor.isColorLut();
    }

    public static void update() {
        if (instance != null) {
            ThresholdAdjuster thresholdAdjuster = (ThresholdAdjuster)instance;
            ImagePlus imagePlus = WindowManager.getCurrentImage();
            if (imagePlus != null && thresholdAdjuster.previousImageID == imagePlus.getID()) {
                thresholdAdjuster.previousImageID = 0;
                thresholdAdjuster.setup(imagePlus);
            }
        }
    }

    static {
        mode = 0;
        methodNames = AutoThresholder.getMethods();
        method = methodNames[0];
        thresholder = new AutoThresholder();
    }
}

