% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icons_section.R
\name{icons_section}
\alias{icons_section}
\title{Icons Section of ISS}
\usage{
icons_section(iss, app_dir, app_desc = "", app_icon = "default.ico",
  prog_menu_icon = TRUE, desktop_icon = TRUE)
}
\arguments{
\item{iss}{Character vector which cumulatively becomes an Inno Setup Script (ISS).}

\item{app_dir}{Development app's directory, defaults to \code{getwd()}.}

\item{app_desc}{Description of Shiny app, appears on mouse-over of icons.}

\item{app_icon}{Filename of icon in \code{app_dir}, used for desktop and program menu shortcuts.}

\item{prog_menu_icon}{Logical. If TRUE, create a program menu shortcut.}

\item{desktop_icon}{Logical. If TRUE, create a desktop shortcut.}
}
\value{
Chainable character vector, which can be used as the \code{text} argument of \code{\link{writeLines}} to generate an ISS.
}
\description{
Shortcuts Inno Setup creates in the Start Menu and/or other locations,
such as the desktop. For more information, see \href{http://www.jrsoftware.org/ishelp/topic_iconssection.htm}{[Icons] section}, or call \code{inno_doc()}.
}
\examples{
\dontrun{
start_iss('myapp') \%>\%
  icons_section(app_desc = 'This Shiny app is awesome!')
}

}
\seealso{
\code{\link{get_R}}, \code{\link{copy_installation}}, \code{\link{create_config}}, \code{\link{create_bat}}, \code{\link{directives_section}}, \code{\link{setup_section}}, \code{\link{languages_section}}, \code{\link{tasks_section}}, \code{\link{files_section}}, \code{\link{icons_section}}, \code{\link{run_section}}, and \code{\link{code_section}}.
}
\author{
Jonathan M. Hill
}
