/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.arima.estimation.LikelihoodStatistics;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.tramo.TramoProcessor;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.stats.LjungBoxTest;
import ec.tstoolkit.stats.SkewnessTest;
import ec.tstoolkit.stats.StabilityTest;

public class ModelStatistics {
    public final int outliers;
    public final int nz;
    public final int neffective;
    public final double bic;
    public final double se;
    public final double ljungBox;
    public final double ljungBoxPvalue;
    public final double seasLjungBox;
    public final double seasLjungBoxPvalue;
    public final double skewnessAbsvalue;
    public final double skewnessPvalue;
    public final boolean stableMean;
    public final boolean stableVar;

    public int getStabilityScore() {
        int s = 0;
        if (!this.stableMean) {
            s = 1;
        }
        if (!this.stableVar) {
            s += 2;
        }
        return s;
    }

    public ModelStatistics(PreprocessingModel m) {
        this.outliers = m.description.getOutliers().size();
        this.nz = m.description.getY().length;
        RegArimaEstimation<SarimaModel> est = new RegArimaEstimation<SarimaModel>(m.estimation.getRegArima(), m.estimation.getLikelihood());
        int nhp = m.description.getArimaComponent().getFreeParametersCount();
        LikelihoodStatistics stats = est.statistics(nhp, 0.0);
        this.bic = stats.BICC;
        this.se = Math.sqrt(stats.SsqErr / (double)(stats.effectiveObservationsCount - stats.estimatedParametersCount + 1));
        this.neffective = stats.effectiveObservationsCount;
        SarimaSpecification spec = ((SarimaModel)est.model.getArima()).getSpecification();
        int n = TramoProcessor.calcLBLength(spec.getFrequency());
        ReadDataBlock res = new ReadDataBlock(est.likelihood.getResiduals());
        int nres = res.getLength();
        LjungBoxTest lb = new LjungBoxTest();
        lb.setHyperParametersCount(nhp);
        lb.setK(n);
        lb.test(res);
        if (lb.isValid()) {
            this.ljungBox = lb.getValue();
            this.ljungBoxPvalue = lb.getPValue();
        } else {
            this.ljungBox = 0.0;
            this.ljungBoxPvalue = 0.0;
        }
        SkewnessTest sk = new SkewnessTest();
        sk.test(res);
        if (sk.isValid()) {
            this.skewnessPvalue = sk.getPValue();
            this.skewnessAbsvalue = Math.abs(sk.getValue());
        } else {
            this.skewnessAbsvalue = 0.0;
            this.skewnessPvalue = 0.0;
        }
        if (spec.getFrequency() > 1) {
            LjungBoxTest lbs = new LjungBoxTest();
            lbs.setK(2);
            lbs.setLag(spec.getFrequency());
            lbs.usePositiveAc(true);
            lbs.test(res);
            if (lbs.isValid()) {
                this.seasLjungBox = lbs.getValue();
                this.seasLjungBoxPvalue = lbs.getPValue();
            } else {
                this.seasLjungBox = 0.0;
                this.seasLjungBoxPvalue = 0.0;
            }
        } else {
            this.seasLjungBox = 0.0;
            this.seasLjungBoxPvalue = 0.0;
        }
        StabilityTest stfull = new StabilityTest();
        stfull.process(res);
        boolean samemean = stfull.isSameMean();
        boolean samevar = stfull.isSameVariance();
        int nlast = 10 * spec.getFrequency();
        if (nlast < nres) {
            StabilityTest stlast = new StabilityTest();
            stlast.process(res.rextract(nres - nlast, nlast));
            boolean samelmean = stlast.isSameMean();
            boolean samelvar = stlast.isSameVariance();
            if (!samemean && samelmean || samemean == samelmean && !samevar && samelvar) {
                samemean = samelmean;
                samevar = samelvar;
            }
        }
        this.stableMean = samemean;
        this.stableVar = samevar;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("nz=").append(this.nz).append(System.lineSeparator());
        builder.append("effective nobs=").append(this.neffective).append(System.lineSeparator());
        builder.append("outliers=").append(this.outliers).append(System.lineSeparator());
        builder.append("bic=").append(this.bic).append(System.lineSeparator());
        builder.append("se=").append(this.se).append(System.lineSeparator());
        builder.append("Q=").append(this.ljungBox).append(" (pvalue=").append(this.ljungBoxPvalue).append(")\r\n");
        builder.append("Qs=").append(this.seasLjungBox).append(" (pvalue=").append(this.seasLjungBoxPvalue);
        return builder.toString();
    }
}

