/*
 * Decompiled with CFR 0.152.
 */
package demetra.information;

import demetra.information.InformationExtractor;
import demetra.information.InformationMappingExtension;
import ec.tstoolkit.utilities.WildCards;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.function.Function;

public class InformationMapping<S>
implements InformationExtractor<S> {
    private final LinkedHashMap<String, InformationExtractor<S>> map = new LinkedHashMap();
    private final Class<S> sourceClass;

    public InformationMapping(Class<S> sourceClass) {
        this.sourceClass = sourceClass;
    }

    public static void updateAll(ClassLoader loader) {
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        ServiceLoader<InformationMappingExtension> services = ServiceLoader.load(InformationMappingExtension.class, loader);
        HashSet set = new HashSet();
        for (InformationMappingExtension informationMappingExtension : services) {
            set.add(informationMappingExtension.getSourceClass());
        }
        for (Class clazz : set) {
            InformationMapping.update(clazz, loader);
        }
    }

    public static boolean update(Class sourceClass, ClassLoader loader) {
        try {
            Method method = sourceClass.getMethod("getMapping", new Class[0]);
            if (method == null) {
                return false;
            }
            InformationMapping rslt = (InformationMapping)method.invoke(null, new Object[0]);
            if (!rslt.sourceClass.equals(sourceClass)) {
                return false;
            }
            rslt.update(loader);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void update() {
        this.update(null);
    }

    public void update(ClassLoader loader) {
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        ServiceLoader<InformationMappingExtension> services = ServiceLoader.load(InformationMappingExtension.class, loader);
        for (InformationMappingExtension extension : services) {
            if (!extension.getSourceClass().equals(this.sourceClass)) continue;
            extension.updateExtractors(this);
        }
    }

    public <Q> void set(String name, Class<Q> targetClass, Function<S, Q> fn) {
        this.map.put(name, InformationExtractor.extractor(name, targetClass, fn));
    }

    public <Q> void delegate(String name, InformationMapping<Q> mapping, Function<S, Q> fn) {
        this.map.put(name, InformationExtractor.delegate(name, mapping, fn));
    }

    public <Q> void delegateArray(String name, int start, int end, InformationMapping<Q> mapping, BiFunction<S, Integer, Q> fn) {
        this.map.put(name, InformationExtractor.delegateArray(name, start, end, mapping, fn));
    }

    public <Q> void setArray(String name, int start, int end, Class<Q> targetClass, BiFunction<S, Integer, Q> fn) {
        this.map.put(name, InformationExtractor.array(name, start, end, targetClass, fn));
    }

    public <Q> void setArray(String name, int defparam, Class<Q> targetClass, BiFunction<S, Integer, Q> fn) {
        this.map.put(name, InformationExtractor.array(name, defparam, targetClass, fn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillDictionary(String prefix, Map<String, Class> dic, boolean compact) {
        InformationMapping informationMapping = this;
        synchronized (informationMapping) {
            this.map.forEach((key, extractor) -> extractor.fillDictionary(prefix, dic, compact));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InformationExtractor<S> search(String id) {
        InformationMapping informationMapping = this;
        synchronized (informationMapping) {
            InformationExtractor<S> extractor = this.map.get(id);
            if (extractor != null) {
                return extractor;
            }
            Optional<Map.Entry> findFirst = this.map.entrySet().stream().filter(entry -> ((InformationExtractor)entry.getValue()).contains(id)).findFirst();
            if (findFirst.isPresent()) {
                return (InformationExtractor)findFirst.get().getValue();
            }
            return null;
        }
    }

    @Override
    public boolean contains(String id) {
        InformationExtractor<S> extractor = this.search(id);
        return extractor == null ? false : extractor.contains(id);
    }

    @Override
    public <T> T getData(S source, String id, Class<T> tclass) {
        InformationExtractor<S> extractor = this.search(id);
        return extractor == null ? null : (T)extractor.getData(source, id, tclass);
    }

    @Override
    public <T> void searchAll(S source, WildCards wc, Class<T> tclass, Map<String, T> all) {
        this.map.forEach((name, extractor) -> extractor.searchAll(source, wc, tclass, all));
    }
}

