/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.dstats;

import ec.tstoolkit.dstats.BoundaryType;
import ec.tstoolkit.dstats.DStatException;
import ec.tstoolkit.dstats.IContinuousDistribution;
import ec.tstoolkit.dstats.ProbabilityType;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.random.IRandomNumberGenerator;

public class Gamma
implements IContinuousDistribution {
    public static final double MAXGAM = 171.6243769563027;
    private final double alpha;
    private final double beta;
    private static final double MAXSTIR = 143.01608;

    public Gamma(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
    }

    @Override
    public double getDensity(double x) throws DStatException {
        if (x < 0.0) {
            throw new IllegalArgumentException();
        }
        if (x == 0.0) {
            if (this.alpha == 1.0) {
                return 1.0 / this.beta;
            }
            return 0.0;
        }
        if (this.alpha == 1.0) {
            return Math.exp(-x / this.beta) / this.beta;
        }
        return Math.exp((this.alpha - 1.0) * Math.log(x / this.beta) - x / this.beta - Gamma.logGamma(this.alpha)) / this.beta;
    }

    public double getShape() {
        return this.alpha;
    }

    public double getScale() {
        return this.beta;
    }

    @Override
    public double getLeftBound() {
        return 0.0;
    }

    @Override
    public double getRightBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Gamma with shape = ");
        sb.append(this.alpha);
        sb.append(" and scale = ");
        sb.append(this.beta);
        return sb.toString();
    }

    @Override
    public double getExpectation() throws DStatException {
        return this.alpha * this.beta;
    }

    @Override
    public double getProbability(double x, ProbabilityType pt) throws DStatException {
        if (x < 0.0 || pt == ProbabilityType.Point) {
            return 0.0;
        }
        if (pt == ProbabilityType.Lower) {
            return Gamma.incompleteGamma(this.alpha, x / this.beta);
        }
        return 1.0 - Gamma.incompleteGamma(this.alpha, x / this.beta);
    }

    @Override
    public double getProbabilityInverse(double p, ProbabilityType pt) throws DStatException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getVariance() throws DStatException {
        return this.alpha * (this.beta * this.beta);
    }

    @Override
    public BoundaryType hasLeftBound() {
        return BoundaryType.Finite;
    }

    @Override
    public BoundaryType hasRightBound() {
        return BoundaryType.None;
    }

    @Override
    public boolean isSymmetrical() {
        return false;
    }

    @Override
    public double random(IRandomNumberGenerator rng) throws DStatException {
        double w;
        double sign_u;
        double e;
        double q;
        double v;
        double v2;
        double v1;
        double v12;
        double a = this.alpha;
        double aa = -1.0;
        double aaa = -1.0;
        double b = 0.0;
        double c = 0.0;
        double d = 0.0;
        double s = 0.0;
        double si = 0.0;
        double ss = 0.0;
        double q0 = 0.0;
        double q1 = 0.0416666664;
        double q2 = 0.0208333723;
        double q3 = 0.0079849875;
        double q4 = 0.0015746717;
        double q5 = -3.349403E-4;
        double q6 = 3.340332E-4;
        double q7 = 6.053049E-4;
        double q8 = -4.701849E-4;
        double q9 = 1.71032E-4;
        double a1 = 0.333333333;
        double a2 = -0.249999949;
        double a3 = 0.199999867;
        double a4 = -0.166677482;
        double a5 = 0.142873973;
        double a6 = -0.124385581;
        double a7 = 0.11036831;
        double a8 = -0.112750886;
        double a9 = 0.104089866;
        double e1 = 1.0;
        double e2 = 0.499999994;
        double e3 = 0.166666848;
        double e4 = 0.041664508;
        double e5 = 0.008345522;
        double e6 = 0.001353826;
        double e7 = 2.47453E-4;
        if (a < 1.0) {
            double gds;
            b = 1.0 + 0.36788794412 * a;
            while (true) {
                double p;
                if ((p = b * rng.nextDouble()) <= 1.0) {
                    gds = Math.exp(Math.log(p) / a);
                    if (!(Math.log(rng.nextDouble()) <= -gds)) continue;
                    return gds * this.beta;
                }
                gds = -Math.log((b - p) / a);
                if (Math.log(rng.nextDouble()) <= (a - 1.0) * Math.log(gds)) break;
            }
            return gds * this.beta;
        }
        if (a != aa) {
            ss = a - 0.5;
            s = Math.sqrt(ss);
            d = 5.656854249 - 12.0 * s;
        }
        while ((v12 = (v1 = 2.0 * rng.nextDouble() - 1.0) * v1 + (v2 = 2.0 * rng.nextDouble() - 1.0) * v2) > 1.0) {
        }
        double t = v1 * Math.sqrt(-2.0 * Math.log(v12) / v12);
        double x = s + 0.5 * t;
        double gds = x * x;
        if (t >= 0.0) {
            return gds * this.beta;
        }
        double u = rng.nextDouble();
        if (d * u <= t * t * t) {
            return gds * this.beta;
        }
        if (a != aaa) {
            double r = 1.0 / a;
            q0 = ((((((((q9 * r + q8) * r + q7) * r + q6) * r + q5) * r + q4) * r + q3) * r + q2) * r + q1) * r;
            if (a > 3.686) {
                if (a > 13.022) {
                    b = 1.77;
                    si = 0.75;
                    c = 0.1515 / s;
                } else {
                    b = 1.654 + 0.0076 * ss;
                    si = 1.68 / s + 0.275;
                    c = 0.062 / s + 0.024;
                }
            } else {
                b = 0.463 + s - 0.178 * ss;
                si = 1.235;
                c = 0.195 / s - 0.079 + 0.016 * s;
            }
        }
        if (x > 0.0) {
            v = t / (s + s);
            q = Math.abs(v) > 0.25 ? q0 - s * t + 0.25 * t * t + (ss + ss) * Math.log(1.0 + v) : q0 + 0.5 * t * t * ((((((((a9 * v + a8) * v + a7) * v + a6) * v + a5) * v + a4) * v + a3) * v + a2) * v + a1) * v;
            if (Math.log(1.0 - u) <= q) {
                return gds * this.beta;
            }
        }
        do {
            e = -Math.log(rng.nextDouble());
            u = rng.nextDouble();
        } while ((t = b + e * si * (sign_u = (u = u + u - 1.0) > 0.0 ? 1.0 : -1.0)) <= -0.71874483771719 || (q = Math.abs(v = t / (s + s)) > 0.25 ? q0 - s * t + 0.25 * t * t + (ss + ss) * Math.log(1.0 + v) : q0 + 0.5 * t * t * ((((((((a9 * v + a8) * v + a7) * v + a6) * v + a5) * v + a4) * v + a3) * v + a2) * v + a1) * v) <= 0.0 || !(c * u * sign_u <= (w = q > 0.5 ? Math.exp(q) - 1.0 : ((((((e7 * q + e6) * q + e5) * q + e4) * q + e3) * q + e2) * q + e1) * q) * Math.exp(e - 0.5 * t * t)));
        x = s + 0.5 * t;
        return x * x * this.beta;
    }

    public static double beta(double a, double b) throws ArithmeticException {
        double y = a + b;
        if ((y = Gamma.gamma(y)) == 0.0) {
            return 1.0;
        }
        if (a > b) {
            y = Gamma.gamma(a) / y;
            y *= Gamma.gamma(b);
        } else {
            y = Gamma.gamma(b) / y;
            y *= Gamma.gamma(a);
        }
        return y;
    }

    public static double gamma(double x) throws ArithmeticException {
        double[] P = new double[]{1.6011952247675185E-4, 0.0011913514700658638, 0.010421379756176158, 0.04763678004571372, 0.20744822764843598, 0.4942148268014971, 1.0};
        double[] Q = new double[]{-2.3158187332412014E-5, 5.396055804933034E-4, -0.004456419138517973, 0.011813978522206043, 0.035823639860549865, -0.23459179571824335, 0.0714304917030273, 1.0};
        double q = Math.abs(x);
        if (q > 33.0) {
            if (x < 0.0) {
                double p = Math.floor(q);
                if (p == q) {
                    throw new ArithmeticException("gamma: overflow");
                }
                int i = (int)p;
                double z = q - p;
                if (z > 0.5) {
                    z = q - (p += 1.0);
                }
                if ((z = q * Math.sin(Math.PI * z)) == 0.0) {
                    throw new ArithmeticException("gamma: overflow");
                }
                z = Math.abs(z);
                z = Math.PI / (z * Gamma.stirlingFormula(q));
                return -z;
            }
            return Gamma.stirlingFormula(x);
        }
        double z = 1.0;
        while (x >= 3.0) {
            z *= (x -= 1.0);
        }
        while (x < 0.0) {
            if (x == 0.0) {
                throw new ArithmeticException("gamma: singular");
            }
            if (x > -1.0E-9) {
                return z / ((1.0 + 0.5772156649015329 * x) * x);
            }
            z /= x;
            x += 1.0;
        }
        while (x < 2.0) {
            if (x == 0.0) {
                throw new ArithmeticException("gamma: singular");
            }
            if (x < 1.0E-9) {
                return z / ((1.0 + 0.5772156649015329 * x) * x);
            }
            z /= x;
            x += 1.0;
        }
        if (x == 2.0 || x == 3.0) {
            return z;
        }
        double p = Polynomial.revaluate(P, x -= 2.0);
        q = Polynomial.revaluate(Q, x);
        return z * p / q;
    }

    public static double incompleteBeta(double aa, double bb, double xx) throws ArithmeticException {
        double x;
        double xc;
        double b;
        double a;
        if (aa <= 0.0 || bb <= 0.0) {
            throw new ArithmeticException("ibeta: Domain error!");
        }
        if (xx <= 0.0 || xx >= 1.0) {
            if (xx == 0.0) {
                return 0.0;
            }
            if (xx == 1.0) {
                return 1.0;
            }
            throw new ArithmeticException("ibeta: Domain error!");
        }
        boolean flag = false;
        if (bb * xx <= 1.0 && xx <= 0.95) {
            double t = Gamma.powerSeries(aa, bb, xx);
            return t;
        }
        double w = 1.0 - xx;
        if (xx > aa / (aa + bb)) {
            flag = true;
            a = bb;
            b = aa;
            xc = xx;
            x = w;
        } else {
            a = aa;
            b = bb;
            xc = w;
            x = xx;
        }
        if (flag && b * x <= 1.0 && x <= 0.95) {
            double t = Gamma.powerSeries(a, b, x);
            t = t <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - t;
            return t;
        }
        double y = x * (a + b - 2.0) - (a - 1.0);
        w = y < 0.0 ? Gamma.incompleteBetaFraction1(a, b, x) : Gamma.incompleteBetaFraction2(a, b, x) / xc;
        y = a * Math.log(x);
        double t = b * Math.log(xc);
        if (a + b < 171.6243769563027 && Math.abs(y) < 709.782712893384 && Math.abs(t) < 709.782712893384) {
            t = Math.pow(xc, b);
            t *= Math.pow(x, a);
            t /= a;
            t *= w;
            t *= Gamma.gamma(a + b) / (Gamma.gamma(a) * Gamma.gamma(b));
            if (flag) {
                t = t <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - t;
            }
            return t;
        }
        y += t + Gamma.logGamma(a + b) - Gamma.logGamma(a) - Gamma.logGamma(b);
        t = (y += Math.log(w / a)) < -745.1332191019412 ? 0.0 : Math.exp(y);
        if (flag) {
            t = t <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - t;
        }
        return t;
    }

    public static double incompleteBetaFraction1(double a, double b, double x) throws ArithmeticException {
        double k1 = a;
        double k2 = a + b;
        double k3 = a;
        double k4 = a + 1.0;
        double k5 = 1.0;
        double k6 = b - 1.0;
        double k7 = k4;
        double k8 = a + 2.0;
        double pkm2 = 0.0;
        double qkm2 = 1.0;
        double pkm1 = 1.0;
        double qkm1 = 1.0;
        double ans = 1.0;
        double r = 1.0;
        int n = 0;
        double thresh = 3.330669E-16f;
        do {
            double t;
            double xk = -(x * k1 * k2) / (k3 * k4);
            double pk = pkm1 + pkm2 * xk;
            double qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            xk = x * k5 * k6 / (k7 * k8);
            pk = pkm1 + pkm2 * xk;
            qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if (qk != 0.0) {
                r = pk / qk;
            }
            if (r != 0.0) {
                t = Math.abs((ans - r) / r);
                ans = r;
            } else {
                t = 1.0;
            }
            if (t < thresh) {
                return ans;
            }
            k1 += 1.0;
            k2 += 1.0;
            k3 += 2.0;
            k4 += 2.0;
            k5 += 1.0;
            k6 -= 1.0;
            k7 += 2.0;
            k8 += 2.0;
            if (Math.abs(qk) + Math.abs(pk) > 4.503599627370496E15) {
                pkm2 *= 2.220446049250313E-16;
                pkm1 *= 2.220446049250313E-16;
                qkm2 *= 2.220446049250313E-16;
                qkm1 *= 2.220446049250313E-16;
            }
            if (!(Math.abs(qk) < 2.220446049250313E-16) && !(Math.abs(pk) < 2.220446049250313E-16)) continue;
            pkm2 *= 4.503599627370496E15;
            pkm1 *= 4.503599627370496E15;
            qkm2 *= 4.503599627370496E15;
            qkm1 *= 4.503599627370496E15;
        } while (++n < 300);
        return ans;
    }

    static double incompleteBetaFraction2(double a, double b, double x) throws ArithmeticException {
        double k1 = a;
        double k2 = b - 1.0;
        double k3 = a;
        double k4 = a + 1.0;
        double k5 = 1.0;
        double k6 = a + b;
        double k7 = a + 1.0;
        double k8 = a + 2.0;
        double pkm2 = 0.0;
        double qkm2 = 1.0;
        double pkm1 = 1.0;
        double qkm1 = 1.0;
        double z = x / (1.0 - x);
        double ans = 1.0;
        double r = 1.0;
        int n = 0;
        double thresh = 3.330669E-16f;
        do {
            double t;
            double xk = -(z * k1 * k2) / (k3 * k4);
            double pk = pkm1 + pkm2 * xk;
            double qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            xk = z * k5 * k6 / (k7 * k8);
            pk = pkm1 + pkm2 * xk;
            qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if (qk != 0.0) {
                r = pk / qk;
            }
            if (r != 0.0) {
                t = Math.abs((ans - r) / r);
                ans = r;
            } else {
                t = 1.0;
            }
            if (t < thresh) {
                return ans;
            }
            k1 += 1.0;
            k2 -= 1.0;
            k3 += 2.0;
            k4 += 2.0;
            k5 += 1.0;
            k6 += 1.0;
            k7 += 2.0;
            k8 += 2.0;
            if (Math.abs(qk) + Math.abs(pk) > 4.503599627370496E15) {
                pkm2 *= 2.220446049250313E-16;
                pkm1 *= 2.220446049250313E-16;
                qkm2 *= 2.220446049250313E-16;
                qkm1 *= 2.220446049250313E-16;
            }
            if (!(Math.abs(qk) < 2.220446049250313E-16) && !(Math.abs(pk) < 2.220446049250313E-16)) continue;
            pkm2 *= 4.503599627370496E15;
            pkm1 *= 4.503599627370496E15;
            qkm2 *= 4.503599627370496E15;
            qkm1 *= 4.503599627370496E15;
        } while (++n < 300);
        return ans;
    }

    public static double incompleteGamma(double a, double x) throws ArithmeticException {
        if (x <= 0.0 || a <= 0.0) {
            return 0.0;
        }
        if (x > 1.0 && x > a) {
            return 1.0 - Gamma.incompleteGammaComplement(a, x);
        }
        double ax = a * Math.log(x) - x - Gamma.logGamma(a);
        if (ax < -709.782712893384) {
            return 0.0;
        }
        ax = Math.exp(ax);
        double r = a;
        double c = 1.0;
        double ans = 1.0;
        while ((c *= x / (r += 1.0)) / (ans += c) > (double)1.110223E-16f) {
        }
        return ans * ax / a;
    }

    public static double incompleteGammaComplement(double a, double x) throws ArithmeticException {
        double t;
        if (x <= 0.0 || a <= 0.0) {
            return 1.0;
        }
        if (x < 1.0 || x < a) {
            return 1.0 - Gamma.incompleteGamma(a, x);
        }
        double ax = a * Math.log(x) - x - Gamma.logGamma(a);
        if (ax < -709.782712893384) {
            return 0.0;
        }
        ax = Math.exp(ax);
        double y = 1.0 - a;
        double z = x + y + 1.0;
        double c = 0.0;
        double pkm2 = 1.0;
        double qkm2 = x;
        double pkm1 = x + 1.0;
        double qkm1 = z * x;
        double ans = pkm1 / qkm1;
        do {
            double yc = (y += 1.0) * (c += 1.0);
            double pk = pkm1 * (z += 2.0) - pkm2 * yc;
            double qk = qkm1 * z - qkm2 * yc;
            if (qk != 0.0) {
                double r = pk / qk;
                t = Math.abs((ans - r) / r);
                ans = r;
            } else {
                t = 1.0;
            }
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if (!(Math.abs(pk) > 4.503599627370496E15)) continue;
            pkm2 *= 2.220446049250313E-16;
            pkm1 *= 2.220446049250313E-16;
            qkm2 *= 2.220446049250313E-16;
            qkm1 *= 2.220446049250313E-16;
        } while (t > (double)1.110223E-16f);
        return ans * ax;
    }

    public static double logGamma(double x) throws ArithmeticException {
        double[] A = new double[]{8.116141674705085E-4, -5.950619042843014E-4, 7.936503404577169E-4, -0.002777777777300997, 0.08333333333333319};
        double[] B = new double[]{-1378.2515256912086, -38801.631513463784, -331612.9927388712, -1162370.974927623, -1721737.0082083966, -853555.6642457654};
        double[] C = new double[]{-351.81570143652345, -17064.210665188115, -220528.59055385445, -1139334.4436798252, -2532523.0717758294, -2018891.4143353277};
        if (x < -34.0) {
            double q = -x;
            double w = Gamma.logGamma(q);
            double p = Math.floor(q);
            if (p == q) {
                throw new ArithmeticException("lgam: Overflow");
            }
            double z = q - p;
            if (z > 0.5) {
                z = (p += 1.0) - q;
            }
            if ((z = q * Math.sin(Math.PI * z)) == 0.0) {
                throw new ArithmeticException("lgamma: Overflow");
            }
            z = 1.1447298858494002 - Math.log(z) - w;
            return z;
        }
        if (x < 13.0) {
            double z = 1.0;
            while (x >= 3.0) {
                z *= (x -= 1.0);
            }
            while (x < 2.0) {
                if (x == 0.0) {
                    throw new ArithmeticException("lgamma: Overflow");
                }
                z /= x;
                x += 1.0;
            }
            if (z < 0.0) {
                z = -z;
            }
            if (x == 2.0) {
                return Math.log(z);
            }
            double p = (x -= 2.0) * Polynomial.revaluate(B, x) / Polynomial.revaluate(C, x);
            return Math.log(z) + p;
        }
        if (x > 2.556348E305) {
            throw new ArithmeticException("lgamma: Overflow");
        }
        double q = (x - 0.5) * Math.log(x) - x + 0.9189385332046728;
        if (x > 1.0E8) {
            return q;
        }
        double p = 1.0 / (x * x);
        q = x >= 1000.0 ? (q += ((7.936507936507937E-4 * p - 0.002777777777777778) * p + 0.08333333333333333) / x) : (q += Polynomial.revaluate(A, p) / x);
        return q;
    }

    static double powerSeries(double a, double b, double x) throws ArithmeticException {
        double v;
        double ai = 1.0 / a;
        double u = (1.0 - b) * x;
        double t1 = v = u / (a + 1.0);
        double t = u;
        double n = 2.0;
        double s = 0.0;
        double z = (double)1.110223E-16f * ai;
        while (Math.abs(v) > z) {
            u = (n - b) * x / n;
            v = (t *= u) / (a + n);
            s += v;
            n += 1.0;
        }
        s += t1;
        s += ai;
        u = a * Math.log(x);
        if (a + b < 171.6243769563027 && Math.abs(u) < 709.782712893384) {
            t = Gamma.gamma(a + b) / (Gamma.gamma(a) * Gamma.gamma(b));
            s = s * t * Math.pow(x, a);
        } else {
            t = Gamma.logGamma(a + b) - Gamma.logGamma(a) - Gamma.logGamma(b) + u + Math.log(s);
            s = t < -745.1332191019412 ? 0.0 : Math.exp(t);
        }
        return s;
    }

    static double stirlingFormula(double x) throws ArithmeticException {
        double[] STIR = new double[]{7.873113957930937E-4, -2.2954996161337813E-4, -0.0026813261780578124, 0.0034722222160545866, 0.08333333333334822};
        double w = 1.0 / x;
        double y = Math.exp(x);
        w = 1.0 + w * Polynomial.revaluate(STIR, w);
        if (x > 143.01608) {
            double v = Math.pow(x, 0.5 * x - 0.25);
            y = v * (v / y);
        } else {
            y = Math.pow(x, x - 0.5) / y;
        }
        y = 2.5066282746310007 * y * w;
        return y;
    }
}

