/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.jdr.ws;

import demetra.algorithm.IProcResults;
import demetra.datatypes.sa.SaItemType;
import ec.satoolkit.ISaSpecification;
import ec.satoolkit.tramoseats.TramoSeatsSpecification;
import ec.satoolkit.x13.X13Specification;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.jdr.sa.Processor;
import ec.tstoolkit.timeseries.simplets.TsData;

public class SaItem {
    private final SaItemType saDefinition;
    private IProcResults results;

    public boolean compute(ProcessingContext context) {
        if (this.results != null) {
            return true;
        }
        TsData data = this.saDefinition.getTs().getData();
        if (data == null) {
            return false;
        }
        ISaSpecification curSpec = this.saDefinition.getPointSpec();
        if (curSpec == null) {
            curSpec = this.saDefinition.getEstimationSpec();
        }
        if (curSpec == null) {
            curSpec = this.saDefinition.getDomainSpec();
        }
        if (curSpec instanceof TramoSeatsSpecification) {
            this.results = Processor.tramoseatsWithContext(data, (TramoSeatsSpecification)curSpec, context);
            return true;
        }
        if (curSpec instanceof X13Specification) {
            this.results = Processor.x13WithContext(data, (X13Specification)curSpec, context);
            return true;
        }
        return true;
    }

    public SaItem(SaItemType saDefinition) {
        this.saDefinition = saDefinition;
    }

    public SaItemType getSaDefinition() {
        return this.saDefinition;
    }

    public IProcResults getResults() {
        return this.results;
    }

    public void setResults(IProcResults results) {
        this.results = results;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SaItem)) {
            return false;
        }
        SaItem other = (SaItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SaItemType this$saDefinition = this.getSaDefinition();
        SaItemType other$saDefinition = other.getSaDefinition();
        if (this$saDefinition == null ? other$saDefinition != null : !((Object)this$saDefinition).equals(other$saDefinition)) {
            return false;
        }
        IProcResults this$results = this.getResults();
        IProcResults other$results = other.getResults();
        return !(this$results == null ? other$results != null : !this$results.equals(other$results));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SaItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SaItemType $saDefinition = this.getSaDefinition();
        result = result * 59 + ($saDefinition == null ? 43 : ((Object)$saDefinition).hashCode());
        IProcResults $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : $results.hashCode());
        return result;
    }

    public String toString() {
        return "SaItem(saDefinition=" + this.getSaDefinition() + ", results=" + this.getResults() + ")";
    }
}

