/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm;

import ec.tstoolkit.MetaData;
import ec.tstoolkit.algorithm.IProcDocument;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetHelper;
import ec.tstoolkit.utilities.IModifiable;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractDocument<S extends IProcSpecification, I, R extends IProcResults>
implements IProcDocument<S, I, R>,
IModifiable {
    public static final String LOCKED = "__locked";
    private static final AtomicLong g_id = new AtomicLong(0L);
    private long id_ = g_id.incrementAndGet();
    private boolean locked_;
    private MetaData metadata_;

    @Override
    public long getKey() {
        return this.id_;
    }

    public String getDocumentId() {
        StringBuilder builder = new StringBuilder();
        builder.append("Doc-").append(this.id_);
        return builder.toString();
    }

    @Override
    public MetaData getMetaData() {
        if (this.metadata_ == null) {
            this.metadata_ = new MetaData();
        }
        return this.metadata_;
    }

    protected AbstractDocument() {
    }

    protected AbstractDocument clone() throws CloneNotSupportedException {
        AbstractDocument doc = (AbstractDocument)super.clone();
        if (this.metadata_ != null) {
            doc.metadata_ = this.metadata_.clone();
        }
        doc.id_ = g_id.incrementAndGet();
        return doc;
    }

    @Override
    public boolean isDirty() {
        if (this.metadata_ != null) {
            return this.metadata_.isDirty();
        }
        return false;
    }

    public boolean isLocked() {
        return this.locked_;
    }

    public void setLocked(boolean value) {
        this.locked_ = value;
    }

    @Override
    public void resetDirty() {
        if (this.metadata_ != null) {
            this.metadata_.resetDirty();
        }
    }

    public boolean hasMetaData() {
        return MetaData.isNullOrEmpty(this.metadata_);
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        if (verbose || this.locked_) {
            info.set(LOCKED, Boolean.valueOf(this.locked_));
        }
        if (!MetaData.isNullOrEmpty(this.metadata_)) {
            info.set("metadata", InformationSetHelper.fromMetaData(this.metadata_));
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        Boolean locked;
        if (info == null) {
            return false;
        }
        InformationSet subSet = info.getSubSet("metadata");
        if (subSet != null) {
            this.metadata_ = new MetaData();
            InformationSetHelper.fillMetaData(subSet, this.metadata_);
        }
        if ((locked = info.get(LOCKED, Boolean.class)) != null) {
            this.locked_ = locked;
        }
        return true;
    }
}

