/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.tramoseats;

import ec.satoolkit.AbstractSaSpecification;
import ec.satoolkit.IDefaultSeriesDecomposer;
import ec.satoolkit.ISaSpecification;
import ec.satoolkit.algorithm.implementation.TramoSeatsProcessingFactory;
import ec.satoolkit.benchmarking.SaBenchmarkingSpec;
import ec.satoolkit.seats.SeatsSpecification;
import ec.satoolkit.tramoseats.SeatsDecomposer;
import ec.satoolkit.tramoseats.TramoSeatsException;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.arima.IPreprocessor;
import ec.tstoolkit.modelling.arima.tramo.CalendarSpec;
import ec.tstoolkit.modelling.arima.tramo.TradingDaysSpec;
import ec.tstoolkit.modelling.arima.tramo.TramoSpecification;
import java.util.Map;
import java.util.Objects;

public class TramoSeatsSpecification
extends AbstractSaSpecification
implements ISaSpecification,
Cloneable {
    private static final String SMETHOD = "TS";
    public static final String TRAMO = "tramo";
    public static final String SEATS = "seats";
    public static final String BENCH = "benchmarking";
    public static final String RSA = "method";
    public static final TramoSeatsSpecification RSA0;
    public static final TramoSeatsSpecification RSA1;
    public static final TramoSeatsSpecification RSA2;
    public static final TramoSeatsSpecification RSA3;
    public static final TramoSeatsSpecification RSA4;
    public static final TramoSeatsSpecification RSA5;
    public static final TramoSeatsSpecification RSAfull;
    private TramoSpecification tramoSpec_;
    private SeatsSpecification seatsSpec_;
    private SaBenchmarkingSpec benchSpec_;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        TramoSpecification.fillDictionary(InformationSet.item(prefix, TRAMO), dic);
        SeatsSpecification.fillDictionary(InformationSet.item(prefix, SEATS), dic);
        SaBenchmarkingSpec.fillDictionary(InformationSet.item(prefix, BENCH), dic);
    }

    public static final TramoSeatsSpecification[] allSpecifications() {
        return new TramoSeatsSpecification[]{RSA0, RSA1, RSA2, RSA3, RSA4, RSA5, RSAfull};
    }

    public TramoSeatsSpecification() {
        this.tramoSpec_ = new TramoSpecification();
        this.seatsSpec_ = new SeatsSpecification();
        this.benchSpec_ = new SaBenchmarkingSpec();
    }

    public TramoSeatsSpecification(TramoSpecification tramoSpec, SeatsSpecification seatsSpec) {
        this.tramoSpec_ = tramoSpec;
        this.seatsSpec_ = seatsSpec;
        this.benchSpec_ = new SaBenchmarkingSpec();
    }

    @Override
    public TramoSeatsSpecification clone() {
        try {
            TramoSeatsSpecification spec = (TramoSeatsSpecification)super.clone();
            spec.tramoSpec_ = this.tramoSpec_.clone();
            spec.seatsSpec_ = this.seatsSpec_.clone();
            spec.benchSpec_ = this.benchSpec_.clone();
            return spec;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    public TramoSpecification getTramoSpecification() {
        return this.tramoSpec_;
    }

    public void setTramoSpecification(TramoSpecification tramoSpec) {
        if (tramoSpec == null) {
            throw new IllegalArgumentException(TRAMO);
        }
        this.tramoSpec_ = tramoSpec;
    }

    public SeatsSpecification getSeatsSpecification() {
        return this.seatsSpec_;
    }

    public void setSeatsSpecification(SeatsSpecification seatsSpec) {
        if (seatsSpec == null) {
            throw new IllegalArgumentException(SEATS);
        }
        this.seatsSpec_ = seatsSpec;
    }

    public SaBenchmarkingSpec getBenchmarkingSpecification() {
        return this.benchSpec_;
    }

    public void setBenchmarkingSpecification(SaBenchmarkingSpec benchSpec) {
        if (benchSpec == null) {
            throw new IllegalArgumentException(BENCH);
        }
        this.benchSpec_ = benchSpec;
    }

    public IPreprocessor buildPreprocessor(ProcessingContext context) {
        return this.tramoSpec_.build(context);
    }

    public IDefaultSeriesDecomposer buildDecomposer() {
        return new SeatsDecomposer(this.seatsSpec_);
    }

    @Override
    protected void checkContext(ProcessingContext context) {
        if (!this.tramoSpec_.getRegression().isUsed()) {
            return;
        }
        int nregs = this.tramoSpec_.getRegression().getUserDefinedVariablesCount();
        if (nregs > 0 && !TramoSeatsSpecification.checkVariables(this.tramoSpec_.getRegression().getUserDefinedVariables(), context)) {
            throw new TramoSeatsException("Invalid context");
        }
        CalendarSpec cspec = this.tramoSpec_.getRegression().getCalendar();
        if (!cspec.isUsed()) {
            return;
        }
        TradingDaysSpec td = cspec.getTradingDays();
        if (!td.isUsed()) {
            return;
        }
        if (!TramoSeatsSpecification.checkVariables(td.getUserVariables(), context)) {
            throw new TramoSeatsException("Invalid context");
        }
        if (!TramoSeatsSpecification.checkCalendar(td.getHolidays(), context)) {
            throw new TramoSeatsException("Invalid context");
        }
    }

    public boolean isSystem() {
        return this == RSA0 || this == RSA1 || this == RSA2 || this == RSA3 || this == RSA4 || this == RSA5 || this == RSAfull;
    }

    public TramoSeatsSpecification matchSystem() {
        if (this.isSystem()) {
            return this;
        }
        if (this.equals(RSA0)) {
            return RSA0;
        }
        if (this.equals(RSA1)) {
            return RSA1;
        }
        if (this.equals(RSA2)) {
            return RSA2;
        }
        if (this.equals(RSA3)) {
            return RSA3;
        }
        if (this.equals(RSA4)) {
            return RSA4;
        }
        if (this.equals(RSA5)) {
            return RSA5;
        }
        if (this.equals(RSAfull)) {
            return RSAfull;
        }
        return null;
    }

    public String toString() {
        if (this == RSA0) {
            return "RSA0";
        }
        if (this == RSA1) {
            return "RSA1";
        }
        if (this == RSA2) {
            return "RSA2";
        }
        if (this == RSA3) {
            return "RSA3";
        }
        if (this == RSA4) {
            return "RSA4";
        }
        if (this == RSA5) {
            return "RSA5";
        }
        if (this == RSAfull) {
            return "RSAfull";
        }
        if (this.equals(RSA0)) {
            return "RSA0";
        }
        if (this.equals(RSA1)) {
            return "RSA1";
        }
        if (this.equals(RSA2)) {
            return "RSA2";
        }
        if (this.equals(RSA3)) {
            return "RSA3";
        }
        if (this.equals(RSA4)) {
            return "RSA4";
        }
        if (this.equals(RSA5)) {
            return "RSA5";
        }
        if (this.equals(RSAfull)) {
            return "RSAfull";
        }
        return SMETHOD;
    }

    @Override
    public String toLongString() {
        String s = this.toString();
        if (SMETHOD.equals(s)) {
            return s;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("TS[").append(s).append(']');
        return builder.toString();
    }

    public static TramoSeatsSpecification fromString(String name) {
        if (name.equals("RSA0")) {
            return RSA0;
        }
        if (name.equals("RSA1")) {
            return RSA1;
        }
        if (name.equals("RSA2")) {
            return RSA2;
        }
        if (name.equals("RSA3")) {
            return RSA3;
        }
        if (name.equals("RSA4")) {
            return RSA4;
        }
        if (name.equals("RSA5")) {
            return RSA5;
        }
        if (name.equals("RSAfull")) {
            return RSAfull;
        }
        return new TramoSeatsSpecification();
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet binfo;
        InformationSet sinfo;
        InformationSet specInfo = new InformationSet();
        specInfo.add("algorithm", TramoSeatsProcessingFactory.DESCRIPTOR);
        InformationSet tinfo = this.tramoSpec_.write(verbose);
        if (tinfo != null) {
            specInfo.add(TRAMO, tinfo);
        }
        if ((sinfo = this.seatsSpec_.write(verbose)) != null) {
            specInfo.add(SEATS, sinfo);
        }
        if ((binfo = this.benchSpec_.write(verbose)) != null) {
            specInfo.add(BENCH, binfo);
        }
        return specInfo;
    }

    @Override
    public boolean read(InformationSet info) {
        boolean tok;
        boolean tok2;
        boolean tok3;
        InformationSet tinfo = info.getSubSet(TRAMO);
        if (tinfo != null && !(tok3 = this.tramoSpec_.read(tinfo))) {
            return false;
        }
        InformationSet sinfo = info.getSubSet(SEATS);
        if (sinfo != null && !(tok2 = this.seatsSpec_.read(sinfo))) {
            return false;
        }
        InformationSet binfo = info.getSubSet(BENCH);
        return binfo == null || (tok = this.benchSpec_.read(binfo));
    }

    private boolean getrsa(InformationSet pinfo) {
        String rsa = pinfo.get(RSA, String.class);
        if (rsa != null) {
            TramoSpecification.Default option = TramoSpecification.Default.valueOf(rsa);
            switch (option) {
                case TR0: {
                    this.tramoSpec_ = TramoSpecification.TR0.clone();
                    return true;
                }
                case TR1: {
                    this.tramoSpec_ = TramoSpecification.TR1.clone();
                    return true;
                }
                case TR2: {
                    this.tramoSpec_ = TramoSpecification.TR2.clone();
                    return true;
                }
                case TR3: {
                    this.tramoSpec_ = TramoSpecification.TR3.clone();
                    return true;
                }
                case TR4: {
                    this.tramoSpec_ = TramoSpecification.TR4.clone();
                    return true;
                }
                case TR5: {
                    this.tramoSpec_ = TramoSpecification.TR5.clone();
                    return true;
                }
                case TRfull: {
                    this.tramoSpec_ = TramoSpecification.TRfull.clone();
                    return true;
                }
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TramoSeatsSpecification && this.equals((TramoSeatsSpecification)obj);
    }

    private boolean equals(TramoSeatsSpecification other) {
        return Objects.equals(other.tramoSpec_, this.tramoSpec_) && Objects.equals(other.seatsSpec_, this.seatsSpec_) && Objects.equals(other.benchSpec_, this.benchSpec_);
    }

    public int hashCode() {
        int hash = 5;
        hash = 13 * hash + Objects.hashCode(this.tramoSpec_);
        hash = 13 * hash + Objects.hashCode(this.seatsSpec_);
        return hash;
    }

    static {
        SeatsSpecification sdef = new SeatsSpecification();
        RSA0 = new TramoSeatsSpecification(TramoSpecification.TR0, sdef);
        RSA1 = new TramoSeatsSpecification(TramoSpecification.TR1, sdef);
        RSA2 = new TramoSeatsSpecification(TramoSpecification.TR2, sdef);
        RSA3 = new TramoSeatsSpecification(TramoSpecification.TR3, sdef);
        RSA4 = new TramoSeatsSpecification(TramoSpecification.TR4, sdef);
        RSA5 = new TramoSeatsSpecification(TramoSpecification.TR5, sdef);
        RSAfull = new TramoSeatsSpecification(TramoSpecification.TRfull, sdef);
    }
}

