/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.DayOfWeek;
import ec.tstoolkit.timeseries.regression.ITradingDaysVariable;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.Arrays;
import java.util.List;

public class StockTradingDaysVariables
implements ITradingDaysVariable,
Cloneable {
    private final int w_;

    public StockTradingDaysVariables(int w) {
        this.w_ = w;
    }

    public StockTradingDaysVariables clone() {
        try {
            StockTradingDaysVariables td = (StockTradingDaysVariables)super.clone();
            return td;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    @Override
    public TsDomain getDefinitionDomain() {
        return null;
    }

    @Override
    public TsFrequency getDefinitionFrequency() {
        return TsFrequency.Monthly;
    }

    @Override
    public String getDescription(TsFrequency context) {
        StringBuilder builder = new StringBuilder();
        builder.append("TD Stock [").append(this.w_).append(']');
        return builder.toString();
    }

    @Override
    public int getDim() {
        return 6;
    }

    @Override
    public String getItemDescription(int idx, TsFrequency context) {
        return DayOfWeek.valueOf(idx + 1).toString();
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        return domain.getFrequency() == TsFrequency.Monthly;
    }

    @Override
    public void data(TsDomain domain, List<DataBlock> data) {
        int n = domain.getLength();
        TsPeriod d0 = domain.getStart();
        int conv = 12 / d0.getFrequency().intValue();
        int[] begin = new int[n];
        int[] monthlen = new int[n];
        TsPeriod month = new TsPeriod(TsFrequency.Monthly);
        month.set(d0.getYear(), d0.getPosition() * conv);
        month.move(conv - 1);
        for (int i = 0; i < begin.length; ++i) {
            begin[i] = Day.calc(month.getYear(), month.getPosition(), 0);
            monthlen[i] = Day.getNumberOfDaysByMonth(month.getYear(), month.getPosition());
            month.move(conv);
        }
        double[] z0 = new double[7];
        for (int j = 0; j < n; ++j) {
            Arrays.fill(z0, 0.0);
            int dayofweek = (begin[j] - 3) % 7;
            int mlen = monthlen[j];
            if (dayofweek < 0) {
                dayofweek += 7;
            }
            if (this.w_ >= 0) {
                if (this.w_ < mlen) {
                    mlen = this.w_;
                }
            } else if ((mlen += this.w_) <= 0) {
                mlen = 1;
            }
            int Lastdayofweek = (dayofweek + (mlen - 1)) % 7;
            z0[Lastdayofweek] = 1.0;
            for (int i = 0; i < 6; ++i) {
                DataBlock x = data.get(i);
                x.set(j, z0[i + 1] - z0[0]);
            }
        }
    }
}

