/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.estimation;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.utilities.Jdk6;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRegArimaModel {
    protected BackFilter m_ur;
    protected RegModel m_dregs;
    private DataBlock m_y;
    private boolean m_bmean;
    private double meancorrection;
    private final List<DataBlock> m_x;
    private int[] m_missings;

    protected AbstractRegArimaModel() {
        this.m_x = new ArrayList<DataBlock>();
    }

    protected AbstractRegArimaModel(AbstractRegArimaModel m, boolean ur) {
        this.m_y = m.m_y;
        this.m_bmean = m.m_bmean;
        this.meancorrection = m.meancorrection;
        this.m_missings = m.m_missings;
        this.m_x = Jdk6.newArrayList(m.m_x);
        if (ur) {
            this.m_ur = m.m_ur;
            this.m_dregs = m.m_dregs;
        }
    }

    protected AbstractRegArimaModel(DataBlock y) {
        this.m_y = y;
        this.m_x = new ArrayList<DataBlock>();
    }

    public void addX(DataBlock x) {
        this.m_x.add(x);
        if (this.m_dregs != null) {
            if (this.m_ur.getLength() == 1) {
                this.m_dregs.addX(x);
            } else {
                DataBlock dx = new DataBlock(this.m_y.getLength() - this.m_ur.getDegree());
                this.m_ur.filter(x, dx);
                this.m_dregs.addX(dx);
            }
        }
    }

    private void calcdregs() {
        if (this.m_y == null) {
            return;
        }
        this.m_dregs = new RegModel();
        int n = this.m_y.getLength();
        if (this.m_ur == null) {
            this.calstationarymodel();
        }
        if (this.m_ur.getLength() == 1) {
            if (this.meancorrection == 0.0) {
                this.m_dregs.setY(this.m_y);
            } else {
                DataBlock y = this.m_y.deepClone();
                y.sub(this.meancorrection);
                this.m_dregs.setY(y);
            }
            if (this.m_missings != null) {
                for (int i = 0; i < this.m_missings.length; ++i) {
                    DataBlock m = new DataBlock(n);
                    m.set(this.m_missings[i], 1.0);
                    this.m_dregs.addX(m);
                }
            }
            for (int i = 0; i < this.m_x.size(); ++i) {
                this.m_dregs.addX(this.m_x.get(i));
            }
            this.m_dregs.setMeanCorrection(this.m_bmean);
        } else {
            int i;
            int nur = this.m_ur.getDegree();
            DataBlock dy = new DataBlock(this.m_y.getLength() - nur);
            this.m_ur.filter(this.m_y, dy);
            dy.sub(this.meancorrection);
            this.m_dregs.setY(dy);
            if (this.m_missings != null) {
                for (i = 0; i < this.m_missings.length; ++i) {
                    DataBlock m = new DataBlock(n);
                    m.set(this.m_missings[i], 1.0);
                    DataBlock dm = new DataBlock(n - nur);
                    this.m_ur.filter(m, dm);
                    this.m_dregs.addX(dm);
                }
            }
            for (i = 0; i < this.m_x.size(); ++i) {
                DataBlock dx = new DataBlock(n - nur);
                this.m_ur.filter(this.m_x.get(i), dx);
                this.m_dregs.addX(dx);
            }
            this.m_dregs.setMeanCorrection(this.m_bmean);
        }
    }

    public double[] calcMeanReg(int n) {
        double[] m = new double[n];
        double[] D = this.m_ur.getWeights();
        int d = D.length - 1;
        m[d] = 1.0;
        for (int i = d + 1; i < n; ++i) {
            double s = 1.0;
            for (int j = 1; j <= d; ++j) {
                s -= m[i - j] * D[d - j];
            }
            m[i] = s;
        }
        return m;
    }

    public DataBlock calcRes(IReadDataBlock b) {
        if (b.getLength() != this.getVarsCount()) {
            return null;
        }
        DataBlock res = this.m_y.deepClone();
        res.addAY(-this.meancorrection, new DataBlock(this.calcMeanReg(this.m_y.getLength())));
        int idx = 0;
        if (this.m_bmean) {
            double m = -b.get(idx++);
            res.addAY(m, new DataBlock(this.calcMeanReg(this.m_y.getLength())));
        }
        for (int i = 0; i < this.m_x.size(); ++i) {
            double c = -b.get(idx++);
            res.addAY(c, this.m_x.get(i));
        }
        return res;
    }

    public double getMeanCorrection() {
        return this.meancorrection;
    }

    public void setMeanCorrection(double meancorrection) {
        this.meancorrection = meancorrection;
    }

    protected abstract void calstationarymodel();

    public void clearX() {
        this.m_x.clear();
        this.m_dregs = null;
    }

    protected AbstractRegArimaModel clone() {
        try {
            AbstractRegArimaModel model = (AbstractRegArimaModel)super.clone();
            if (this.m_dregs != null) {
                model.m_dregs = this.m_dregs.clone();
            }
            return model;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    public BackFilter getDifferencingFilter() {
        if (this.m_ur == null) {
            this.calstationarymodel();
        }
        return this.m_ur;
    }

    public RegModel getDModel() {
        if (this.m_dregs == null) {
            this.calcdregs();
        }
        return this.m_dregs;
    }

    public int[] getMissings() {
        return this.m_missings;
    }

    public int getMissingsCount() {
        return this.m_missings == null ? 0 : this.m_missings.length;
    }

    public int getObsCount() {
        return this.m_y.getLength();
    }

    public int getVarsCount() {
        int n = this.m_x.size();
        if (this.m_bmean) {
            ++n;
        }
        if (this.m_missings != null) {
            n += this.m_missings.length;
        }
        return n;
    }

    public int getXCount() {
        return this.m_x.size();
    }

    public DataBlock getY() {
        return this.m_y;
    }

    public void insertX(int pos, IReadDataBlock x) {
        this.insertX(pos, new DataBlock(x));
    }

    public void insertX(int pos, DataBlock x) {
        this.m_x.add(pos, x);
        if (this.m_dregs != null) {
            int del;
            int n = del = this.m_missings == null ? 0 : this.m_missings.length;
            if (this.m_dregs != null) {
                if (this.m_ur.getLength() == 1) {
                    this.m_dregs.insertX(pos + del, x);
                } else {
                    DataBlock dx = new DataBlock(this.m_y.getLength() - this.m_ur.getDegree());
                    this.m_ur.filter(x, dx);
                    this.m_dregs.insertX(pos, x);
                }
            }
        }
    }

    public boolean isMeanCorrection() {
        return this.m_bmean;
    }

    public void removeX(int idx) {
        int del;
        this.m_x.remove(idx);
        int n = del = this.m_missings == null ? 0 : this.m_missings.length;
        if (this.m_dregs != null) {
            this.m_dregs.removeX(idx + del);
        }
    }

    public void removeX(int i0, int n) {
        int del = this.m_missings == null ? 0 : this.m_missings.length;
        for (int i = i0; i < i0 + n; ++i) {
            this.m_x.remove(i);
            if (this.m_dregs == null) continue;
            this.m_dregs.removeX(i + del);
        }
    }

    public void setMeanCorrection(boolean value) {
        this.m_bmean = value;
        if (this.m_dregs != null) {
            this.m_dregs.setMeanCorrection(value);
        }
    }

    public void setMissings(int[] value) {
        this.m_missings = value;
        this.m_dregs = null;
    }

    public void setY(IReadDataBlock value) {
        this.setY(new DataBlock(value));
    }

    public void setY(DataBlock value) {
        this.m_y = value;
        if (this.m_dregs != null) {
            int n = this.m_y.getLength();
            if (this.m_ur == null) {
                this.calstationarymodel();
            }
            if (this.m_ur.getLength() == 1) {
                this.m_dregs.setY(this.m_y);
            } else {
                int nur = this.m_ur.getDegree();
                DataBlock dy = new DataBlock(this.m_y.getLength() - nur);
                this.m_ur.filter(this.m_y, dy);
                this.m_dregs.setY(dy);
            }
        }
    }

    public DataBlock X(int idx) {
        return this.m_x.get(idx);
    }
}

