/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.special;

import ec.tstoolkit.arima.special.MixedAirlineCompositeModel;
import ec.tstoolkit.arima.special.MixedAirlineModel;
import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ParamValidation;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaModelBuilder;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.SsfComposite;

public class MixedAirlineMapper
implements IParametricMapping<ISsf> {
    public static final String TH = "th";
    public static final String BTH = "bth";
    public static final String NVAR = "noise var";
    private final int freq_;
    private final int[] noisyPeriods_;

    public MixedAirlineMapper(MixedAirlineModel m) {
        this.freq_ = m.getFrequency();
        this.noisyPeriods_ = m.getNoisyPeriods();
    }

    @Override
    public ISsf map(IReadDataBlock p) {
        SarimaModelBuilder builder = new SarimaModelBuilder();
        SarimaModel airline = builder.createAirlineModel(this.freq_, p.get(0), p.get(1));
        MixedAirlineCompositeModel model = new MixedAirlineCompositeModel(airline, p.get(2), this.noisyPeriods_);
        return new SsfComposite(model);
    }

    @Override
    public IReadDataBlock map(ISsf t) {
        if (!(t instanceof SsfComposite)) {
            return null;
        }
        SsfComposite ct = (SsfComposite)t;
        if (!(ct.getCompositeModel() instanceof MixedAirlineCompositeModel)) {
            return null;
        }
        MixedAirlineCompositeModel cm = (MixedAirlineCompositeModel)ct.getCompositeModel();
        double[] p = new double[]{cm.getAirline().theta(1), cm.getAirline().btheta(1), cm.getNoiseWeight()};
        return new ReadDataBlock(p);
    }

    @Override
    public String getDescription(int idx) {
        switch (idx) {
            case 0: {
                return TH;
            }
            case 1: {
                return BTH;
            }
            case 2: {
                return NVAR;
            }
        }
        return "parameter " + idx;
    }

    @Override
    public boolean checkBoundaries(IReadDataBlock inparams) {
        return true;
    }

    @Override
    public double epsilon(IReadDataBlock inparams, int idx) {
        return 1.0E-4;
    }

    @Override
    public int getDim() {
        return 3;
    }

    @Override
    public double lbound(int idx) {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double ubound(int idx) {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public ParamValidation validate(IDataBlock ioparams) {
        return ParamValidation.Valid;
    }
}

