/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import it.bancaditalia.oss.sdmx.util.SdmxException;

class DataCache {
    private static final int NAME_COL = 0;
    private static final int TIME_COL = 1;
    private static final int OBS_COL = 2;
    private static final int STATUS_COL = 3;
    Object[][] data = null;

    DataCache(int n) {
        this.data = new Object[n][4];
    }

    void setRow(int n, String string, String string2, double d, String string3) throws SdmxException {
        if (this.data == null || n >= this.data.length) {
            throw new SdmxException("Row index exceeds data size");
        }
        this.data[n][0] = string;
        this.data[n][1] = string2;
        this.data[n][2] = new Double(d);
        this.data[n][3] = string3;
    }

    double getObservation(int n) throws SdmxException {
        if (this.data != null && n < this.data.length) {
            return (Double)this.data[n][2];
        }
        throw new SdmxException("Data cache error: cache is null or index exceeds size.");
    }

    String getName(int n) throws SdmxException {
        if (this.data != null && n < this.data.length) {
            return (String)this.data[n][0];
        }
        throw new SdmxException("Data cache error: cache is null or index exceeds size.");
    }

    String getStatus(int n) throws SdmxException {
        if (this.data != null && n < this.data.length) {
            return (String)this.data[n][3];
        }
        throw new SdmxException("Data cache error: cache is null or index exceeds size.");
    }

    String getTimestamp(int n) throws SdmxException {
        if (this.data != null && n < this.data.length) {
            return (String)this.data[n][1];
        }
        throw new SdmxException("Data cache error: cache is null or index exceeds size.");
    }

    int size() {
        if (this.data != null) {
            return this.data.length;
        }
        return -1;
    }
}

