% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEMKL.Classification.R
\name{SEMKL.classification}
\alias{SEMKL.classification}
\title{Simple and Efficient MKL}
\usage{
SEMKL.classification(k, outcome, penalty, tol = 1e-04,
  max.iters = 1000)
}
\arguments{
\item{k}{list of Gramm matrices}

\item{outcome}{vector of binary outcome -1 and 1}

\item{penalty}{penalty of the smoothness of the resulting desicion rules}

\item{tol}{change between to iterations is smaller than this, algorithms is considered to have converged}

\item{max.iters}{maximum number of allowed iteratons}
}
\value{
gamma weight vector for the importnace of each kernel

alpha coeffiencents of the dual of MKL

time total amount of time to train model

iters Numvber of iterations to reach convergence criteria

gamma_all Kernel weights for each interation of SEMKL
}
\description{
This function conducts Simple and Efficnent MKL for precomputed gramm matrices
}
\examples{
data(benchmark.data)
example.data=benchmark.data[[1]]
#Load data
training.samples=sample(1:dim(example.data)[1],floor(0.7*dim(example.data)[1]),replace=FALSE)
# Split samples into training and test sets 
C=1
kernels=c('radial','polynomial')
degree=c(0,2)
scale=c(0,2)
sigma=c(2,0)
K=kernels.gen(example.data[,1:2], training.samples, kernels, degree, scale, sigma)
K.train=K$K.train
SEMKL.classification(K.train,example.data[training.samples,3], C)
}
