/*
 * Decompiled with CFR 0.152.
 */
package de.hzi.infg;

import de.hzi.infg.exceptions.ErrorFromWebserviceExeption;
import de.hzi.infg.exceptions.NoResultSoFarException;
import de.hzi.infg.exceptions.ParameterNotFoundException;
import de.hzi.infg.interfaces.RequestInterface;
import de.hzi.infg.interfaces.TypeInterface;
import de.hzi.infg.utilities.Utils;
import gov.nih.nlm.ncbi.www.soap.eutils.EUtilsServiceStub;
import gov.nih.nlm.ncbi.www.soap.eutils.einfo.DbListType;
import gov.nih.nlm.ncbi.www.soap.eutils.einfo.EInfoRequest;
import gov.nih.nlm.ncbi.www.soap.eutils.einfo.EInfoResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RequestEInfo
implements RequestInterface {
    private String[] dbNames;
    private Map<String, Object> dbInfoMap;
    private boolean isDbInfo = false;
    private EInfoResult result;
    private EInfoRequest request;

    public RequestEInfo(Map<String, String> arguments, EUtilsServiceStub service) throws ErrorFromWebserviceExeption, RemoteException {
        if (arguments.get("db").isEmpty()) {
            this.request = new EInfoRequest(arguments.keySet());
            if (!arguments.get("email").isEmpty()) {
                this.request.setEmail(arguments.get("email"));
            }
            if (!arguments.get("tool").isEmpty()) {
                this.request.setTool(arguments.get("tool"));
            }
            this.result = service.run_eInfo(this.request);
            service.cleanup();
            DbListType dbList = this.result.getDbList();
            this.dbNames = dbList.getDbName();
            this.isDbInfo = false;
        } else {
            EInfoRequest request = new EInfoRequest(arguments.keySet());
            request.setDb(arguments.get("db"));
            if (!arguments.get("email").isEmpty()) {
                request.setEmail(arguments.get("email"));
            }
            if (!arguments.get("tool").isEmpty()) {
                request.setTool(arguments.get("tool"));
            }
            this.result = service.run_eInfo(request);
            service.cleanup();
            if (this.result.getERROR() != null) {
                throw new ErrorFromWebserviceExeption("The request produced an error: " + this.result.getERROR());
            }
            this.dbInfoMap = this.result.getDbInfo().getParametersMap();
            this.isDbInfo = true;
        }
    }

    public String[] getDbNames() {
        return this.dbNames;
    }

    public Map<String, Object> getDbInfoMap() {
        return this.dbInfoMap;
    }

    public boolean isDbInfo() {
        return this.isDbInfo;
    }

    @Override
    public String[] getParameterByName(String parameter) throws ParameterNotFoundException {
        if (!this.isDbInfo) {
            return null;
        }
        Object tmpObj = this.dbInfoMap.get(parameter.toLowerCase());
        if (tmpObj == null) {
            throw new ParameterNotFoundException("The parameter \"" + parameter + "\" has no further parameters to get.");
        }
        if (tmpObj instanceof String) {
            String[] tmp = new String[]{tmpObj.toString()};
            return tmp;
        }
        Object[] objAr = (Object[])tmpObj;
        Map<String, Object> tmpParaMap = ((TypeInterface)objAr[0]).getParametersMap();
        return tmpParaMap.keySet().toArray(new String[tmpParaMap.keySet().size()]);
    }

    @Override
    public String[] getParameter() {
        ArrayList<String> tmpList = new ArrayList<String>();
        for (String name : this.dbInfoMap.keySet()) {
            Object obj = this.dbInfoMap.get(name);
            if (!(obj instanceof String)) {
                tmpList.add(name);
                tmpList.add("true");
                continue;
            }
            tmpList.add(name);
            tmpList.add("false");
        }
        return tmpList.toArray(new String[tmpList.size()]);
    }

    @Override
    public String[] getComplexType(String name) throws ParameterNotFoundException {
        ArrayList<String> listToReturn = new ArrayList<String>();
        Object tmpObj = this.dbInfoMap.get(name.toLowerCase());
        if (tmpObj == null) {
            throw new ParameterNotFoundException("The parameter \"" + name + "\" is not part of this result.");
        }
        if (tmpObj instanceof String) {
            throw new ParameterNotFoundException("The parameter \"" + name + "\" is not a complex type.");
        }
        Object[] objAr = (Object[])tmpObj;
        Class<?> complexTypSubClass = objAr[0].getClass();
        String[] tmpAr = this.getParameterByName(name);
        String parNames = "";
        ArrayList<String> orderedNames = new ArrayList<String>();
        HashMap<String, Method> getters = new HashMap<String, Method>();
        int i = 0;
        while (i < tmpAr.length) {
            getters.put(tmpAr[i], Utils.getGetMethodByName(tmpAr[i], complexTypSubClass));
            orderedNames.add(tmpAr[i]);
            parNames = i == tmpAr.length - 1 ? String.valueOf(parNames) + tmpAr[i] : String.valueOf(parNames) + tmpAr[i] + "{bw}";
            ++i;
        }
        listToReturn.add(parNames);
        HashMap tmpMap = new HashMap();
        Object[] objectArray = objAr;
        int n = objAr.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            for (String methodName : getters.keySet()) {
                Object returnOfGet;
                ArrayList<Object> tmpArrList = (ArrayList<Object>)tmpMap.get(methodName);
                if (tmpArrList == null) {
                    tmpArrList = new ArrayList<Object>();
                    tmpMap.put(methodName, tmpArrList);
                }
                try {
                    returnOfGet = ((Method)getters.get(methodName)).invoke(object, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    throw new ParameterNotFoundException("Something is wrong with the parameter \"" + name + "\". Could not find get methods for this complex type");
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    throw new ParameterNotFoundException("Something is wrong with the parameter \"" + name + "\". Could not find get methods for this complex type");
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    throw new ParameterNotFoundException("Something is wrong with the parameter \"" + name + "\". Could not find get methods for this complex type");
                }
                tmpArrList.add(returnOfGet);
            }
            ++n2;
        }
        int j = 0;
        while (j < orderedNames.size()) {
            String tmpString = "";
            if (listToReturn.size() > j + 1) {
                tmpString = (String)listToReturn.get(j + 1);
            }
            ArrayList tmpArrList = (ArrayList)tmpMap.get(orderedNames.get(j));
            int i2 = 0;
            while (i2 < tmpArrList.size()) {
                tmpString = i2 == tmpArrList.size() - 1 ? String.valueOf(tmpString) + tmpArrList.get(i2) : String.valueOf(tmpString) + tmpArrList.get(i2) + "{bw}";
                ++i2;
            }
            listToReturn.add(j + 1, tmpString);
            ++j;
        }
        return listToReturn.toArray(new String[listToReturn.size()]);
    }

    @Override
    public String getSimpleType(String name) throws ParameterNotFoundException {
        Object stringToReturn = null;
        stringToReturn = this.dbInfoMap.get(name);
        if (stringToReturn == null) {
            throw new ParameterNotFoundException("The parameter \"" + name + "\" is not part of this result.");
        }
        if (!(stringToReturn instanceof String)) {
            throw new ParameterNotFoundException("The parameter \"" + name + "\" is a complex type.");
        }
        return (String)stringToReturn;
    }

    @Override
    public Map<String, Object> getResultMap() throws NoResultSoFarException {
        return null;
    }
}

