% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getOrCreateNode.R
\name{getOrCreateNode}
\alias{getOrCreateNode}
\title{Create Unique Node or Retrieve Unique Node}
\usage{
getOrCreateNode(graph, .label, ...)
}
\arguments{
\item{graph}{A graph object.}

\item{.label}{A character string.}

\item{...}{A named list. Node properties in the form key = value.}
}
\value{
A node object.
}
\description{
Create a unique node or retrieve it if it already exists.
}
\details{
A uniqueness constraint must exist for the given node label and first key = value pair
listed in \code{...}. Use \code{\link{addConstraint}} to add a uniqueness constraint.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

createNode(graph, "Person", name = "Alice", age = 24)
createNode(graph, "Person", name = "Bob", age = 21)

addConstraint(graph, "Person", "name")

# Alice is retrieved from the graph; a new node is not created.
alice = getOrCreateNode(graph, "Person", name = "Alice")

# Additional properties listed after the unique key = value
# pair are ignored if the node is retrieved instead of
# created.
bob = getOrCreateNode(graph, "Person", name = "Bob", age = 22)

# Node doesn't exist, so it is created.
charles = getOrCreateNode(graph, "Person", name = "Charles")

# There are now three nodes in the graph.
length(getLabeledNodes(graph, "Person"))
}
}

