% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getConstraint.R
\name{getConstraint}
\alias{getConstraint}
\title{Uniqueness Constraints}
\usage{
getConstraint(graph, label = character())
}
\arguments{
\item{graph}{A graph object.}

\item{label}{A character vector.}
}
\value{
A data.frame.
}
\description{
Get all uniqueness constraints for a given label or for the entire graph database.
}
\details{
Omitting the \code{label} argument returns all uniqueness constraints in the graph database.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

addConstraint(graph, "Person", "name")
addConstraint(graph, "City", "name")

getConstraint(graph, "Person")
getConstraint(graph)
}
}
\seealso{
\code{\link{addConstraint}}, \code{\link{dropConstraint}}
}

