% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankOrderData.R
\name{rankorderdata}
\alias{rankorderdata}
\title{Rank order data}
\usage{
rankorderdata(score, class, dec = TRUE)
}
\arguments{
\item{score}{A vector containing (diagnostic) scores.}

\item{class}{A vector containing the class.}

\item{dec}{Logical. \code{TRUE} for descending order, \code{FALSE} for
ascending order.}
}
\value{
A dataframe, rank-ordered with respect to the score.
}
\description{
Function \code{rankorderdata} rank-orders the data
with respect to some variable (diagnostic variable).
}
\section{Comment}{

\code{rankorderdata} is used internally in other function(s) of \pkg{ROCit}.
}

\examples{
score <- c(0.4 * runif(20) + 0.2, 0.4*runif(20))
class <- c(rep("A",20), rep("B",20))
returndata <- rankorderdata(score, class, dec = FALSE)
returndata

}
\author{
Riaz Khan, \email{mdriazahmed.khan@jacks.sdstate.edu}
}
