% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measureit.R
\name{measureit.default}
\alias{measureit.default}
\title{Performance Metrics of Binary Classifier}
\usage{
\method{measureit}{default}(
  score,
  class,
  negref = NULL,
  measure = c("ACC", "SENS"),
  step = FALSE,
  ... = NULL
)
}
\arguments{
\item{score}{An numeric array of diagnostic score.}

\item{class}{An array of equal length of score,
containing the class of the observations.}

\item{negref}{The reference value, same as the
\code{reference} in \code{\link{convertclass}}.
Depending on the class of \code{x},
it can be numeric or character type. If specified, this value
is converted to 0 and other is converted to 1. If NULL, reference is
set alphabetically.}

\item{measure}{The performance metrics to be evaluated. See "Details"
for available options.}

\item{step}{Logical, default in \code{FALSE}.The algorithm used in
\code{measureit} first rank orders the
data and calculates TP, FP, TN, FN by treating all predicted
up to certain level as positive. If \code{step} is \code{TRUE},
then these numbers are evaluated for all the observations,
regardless of tie in the data. If \code{step} is
\code{FALSE}, only one set of stats are retained for a single value of
\code{D}.}

\item{...}{\code{NULL}. Used for S3 generic/method consistency.}
}
\value{
An object of class \code{"measureit"}. By default it contains the
followings:
\item{Cutoff}{Cutoff at which metrics are evaluated.}
\item{Depth}{What portion of the observations fall on or above the cutoff.}
\item{TP}{Number of true positives, when the observations having
score equal or greater than cutoff are predicted positive.}
\item{FP}{Number of false positives, when the observations having
score equal or greater than cutoff are predicted positive.}
\item{TN}{Number of true negatives, when the observations having
score equal or greater than cutoff are predicted positive.}
\item{FN}{Number of false negatives, when the observations having
score equal or greater than cutoff are predicted positive.}

When other metrics are called via \code{measure}, those also appear
in the return in the order they are listed above.
}
\description{
This function  computes various performance metrics
at different cutoff values.
}
\details{
Various performance metrics for binary classifier are
available that are cutoff specific. For a certain cutoff value, all the
observations having score equal or greater are predicted as
positive. Following metrics can be called for
via \code{measure} argument:
\itemize{
\item{\code{ACC:} Overall accuracy of  classification =
\eqn{P(Y = \hat{Y})} = (TP + TN) / (TP + FP + TN + FN)}
\item{\code{MIS:} Misclassification rate = \eqn{1 - ACC}}
\item{\code{SENS:} Sensitivity = \eqn{P(\hat{Y} = 1|Y = 1) = TP / (TP + FN)}}
\item{\code{SPEC:} Specificity = \eqn{P(\hat{Y} = 0|Y = 0) = TN / (TN + FP)}}
\item{\code{PREC:} Precision  = \eqn{P(Y = 1| \hat{Y} = 1) = TP / (TP + FP)}}
\item{\code{REC:} Recall. Same as sensitivity.}
\item{\code{PPV:} Positive predictive value. Same as precision}
\item{\code{NPV:} Positive predictive value = \eqn{P(Y = 0| \hat{Y} = 0) =
TN / (TN + FN)}}
\item{\code{TPR:} True positive rate. Same as sensitivity.}
\item{\code{FPR:} False positive rate. Same as \eqn{1 - specificity}.}
\item{\code{TNR:} True negative rate. Same as specificity.}
\item{\code{FNR:} False negative rate = \eqn{P(\hat{Y} = 0|Y = 1) =
FN / (FN +TP)}}
\item{\code{pDLR:} Positive diagnostic likelihood ratio = \eqn{TPR / FPR}}
\item{\code{nDLR:} Negative diagnostic likelihood ratio = \eqn{FNR / TNR}}
\item{\code{FSCR:} F-score, defined as \eqn{2 * (PPV * TPR) / (PPV + TPR)}}
}
    \emph{Exact match} is required. If the values passed in the
\code{measure} argument do not match with the
available options, then ignored.
}
\note{
The algorithm is designed for complete cases. If NA(s) found in
either \code{score} or \code{class}, then removed.

     Internally sorting is performed, with respect to the
\code{score}. In case of tie, sorting is done with respect to \code{class}.
}
\examples{
data("Diabetes")
logistic.model <- glm(factor(dtest)~chol+age+bmi,
                      data = Diabetes,family = "binomial")
class <- logistic.model$y
score <- logistic.model$fitted.values
# -------------------------------------------------------------
measure <- measureit(score = score, class = class,
                     measure = c("ACC", "SENS", "FSCR"))
names(measure)
plot(measure$ACC~measure$Cutoff, type = "l")
plot(measure$TP~measure$FP, type = "l")

}
\seealso{
\code{\link{measureit.rocit}}, \code{\link{print.measureit}}
}
\author{
Riaz Khan, \email{mdriazahmed.khan@jacks.sdstate.edu}
}
