% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_rocci.R
\name{print.rocci}
\alias{print.rocci}
\title{Print \code{rocci} Object}
\usage{
\method{print}{rocci}(x, ... = NULL)
}
\arguments{
\item{x}{An object of class \code{"rocci"},
returned by \code{\link{ciROC}} function.}

\item{...}{\code{NULL}. Used for S3 generic/method consistency.}
}
\description{
Print \code{rocci} Object
}
\examples{
data("Diabetes")
roc_empirical <- rocit(score = Diabetes$chol, class = Diabetes$dtest,
                       negref = "-") # default method empirical
roc_binormal <- rocit(score = Diabetes$chol, class = Diabetes$dtest,
                     negref = "-", method = "bin")

# ---------------------
print(ciROC(roc_empirical))
print(ciROC(roc_binormal))



}
\seealso{
\code{\link{ciROC}}, \code{\link{rocit}}
}
