% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geiger_functions.R
\name{tips}
\alias{tips}
\title{Get descending tips}
\usage{
tips(tree,node,labels=TRUE)
}
\arguments{
\item{tree}{a phylogenetic tree. The tree needs not to be ultrametric and
fully dichotomous.}

\item{node}{the number of focal node}

\item{labels}{if \code{TRUE} (default) the function returns the labels of descending tips.}
}
\value{
The tips, either labels or numbers depending on the argument \code{labels}, descending from the \code{node}.
}
\description{
The function returns the numbers or labels of tips descending from a given node.
}
\examples{
data(DataOrnithodirans)
DataOrnithodirans$treedino->treedino
tips(tree=treedino,node=677,labels=FALSE)
tips(tree=treedino,node=677,labels=TRUE)
}
\author{
Silvia Castiglione, Pasquale Raia, Carmela Serio
}
