% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSAGA-modules.R
\name{rsaga.grid.calculus}
\alias{rsaga.grid.calculus}
\alias{rsaga.linear.combination}
\title{SAGA Module Grid Calculus}
\usage{
rsaga.grid.calculus(in.grids, out.grid, formula, env = rsaga.env(), ...)

rsaga.linear.combination(
  in.grids,
  out.grid,
  coef,
  cf.digits = 16,
  remove.zeros = FALSE,
  remove.ones = TRUE,
  env = rsaga.env(),
  ...
)
}
\arguments{
\item{in.grids}{input character vector: SAGA grid files (default file extension: \code{.sgrd})}

\item{out.grid}{output: grid file resulting from the cell-by-cell application of 'formula' to the grids. Existing files will be overwritten!}

\item{formula}{character string of formula specifying the arithmetic operation to be performed on the \code{in.grids} (see Details); if this is a formula, only the right hand side will be used.}

\item{env}{RSAGA geoprocessing environment, generated by a call to \code{\link[=rsaga.env]{rsaga.env()}}}

\item{...}{optional arguments to be passed to \code{\link[=rsaga.geoprocessor]{rsaga.geoprocessor()}}}

\item{coef}{numeric: coefficient vector to be used for the linear combination of the \code{in.grids}. If \code{coef} as one more element than \code{in.grids}, the first one will be interpreted as an intercept.}

\item{cf.digits}{integer: number of digits used when converting the \code{coef}ficients to character strings (trailing zeros will be removed)}

\item{remove.zeros}{logical: if \code{TRUE}, terms (grids) with coefficient (numerically) equal to zero (after rounding to \code{cf.digits} digits) will be removed from the formula}

\item{remove.ones}{logical: if \code{TRUE} (the default), factors equal to 1 (after rounding to \code{cf.digits} digits) will be removed from the formula}
}
\value{
The type of object returned depends on the \code{intern} argument passed to the \code{\link[=rsaga.geoprocessor]{rsaga.geoprocessor()}}. For \code{intern=FALSE} it is a numerical error code (0: success), or otherwise (the default) a character vector with the module's console output.
}
\description{
Perform Arithmetic Operations on Grids
}
\details{
The \code{in.grids} are represented in the \code{formula} by the letters \code{a} (for \code{in.grids[1]}), \code{b} etc. Thus, if \code{in.grids[1]} is Landsat TM channel 3 and \code{in.grids[2]} is channel 4, the NDVI formula (TM3-TM4)/(TM3+TM4) can be represented  by the character string \code{"(a-b)/(a+b)"} (any spaces are removed) or the formula \code{~(a-b)/(a+b)} in the \code{formula} argument.

In addition to +, -, *, and /, the following operators and functions are available for the \code{formula} definition:
+ \eqn{\hat{\ }}{^} power
+ \code{sin(a)} sine
+ \code{cos(a)} cosine
+ \code{tan(a)} tangent
+ \code{asin(a)} arc sine
+ \code{acos(a)} arc cosine
+ \code{atan(a)} arc tangent
+ \code{atan2(a,b)} arc tangent of b/a
+ \code{abs(a)} absolute value
+ \code{int(a)} convert to integer
+ \code{sqr(a)} square
+ \code{sqrt(a)} square root
+ \code{ln(a)} natural logarithm
+ \code{log(a)} base 10 logarithm
+ \code{mod(a,b)} modulo
+ \code{gt(a, b)} returns 1 if a greater b
+ \code{lt(a, b)} returns 1 if a lower b
+ \code{eq(a, b)} returns 1 if a equal b
+ \code{ifelse(switch, x, y)} returns x if switch equals 1 else y

Using \code{remove.zeros=FALSE} might have the side effect that no data areas in the grid with coefficient 0 are passed on to the results grid. (To be confirmed.)
}
\examples{
\dontrun{
# using SAGA grids:
# calculate the NDVI from Landsat TM bands 3 and 4:
rsaga.grid.calculus(c("tm3.sgrd","tm4.sgrd"), "ndvi.sgrd", ~(a-b)/(a+b))
# apply a linear regression equation to grids:
coefs = c(20,-0.6)
# maybe from a linear regression of mean annual air temperature (MAAT)
# against elevation - something like:
# coefs = coef( lm( maat ~ elevation ) )
rsaga.linear.combination("elevation.sgrd", "maat.sgrd", coefs)
# equivalent:
rsaga.grid.calculus("elevation.sgrd", "maat.sgrd", "20 - 0.6*a")
}
}
\seealso{
\code{\link[=local.function]{local.function()}}, \code{\link[=focal.function]{focal.function()}}, and \code{\link[=multi.focal.function]{multi.focal.function()}} for a more flexible framework for combining grids or applying local and focal functions; \code{\link[=rsaga.geoprocessor]{rsaga.geoprocessor()}}, \code{\link[=rsaga.env]{rsaga.env()}}
}
\author{
Alexander Brenning (R interface), Olaf Conrad (SAGA module)
}
\keyword{interface}
\keyword{spatial}
