% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interscal.R
\name{interscal}
\alias{interscal}
\title{Interscal Method}
\usage{
interscal(sym.data)
}
\arguments{
\item{sym.data}{The symbolic data matrix.}
}
\value{
The symbolic interval components.
}
\description{
Execute Interscal Method.
}
\examples{
\dontrun{
data(oils)
res<-interscal(oils)
class(res$Sym.Components) <- c('sym.data.table')
sym.scatterplot(res$Sym.Components[,1], res$Sym.Components[,2],
                labels=TRUE,col='red',main='Interscal CFA Data')
sym.scatterplot3d(res$Sym.Components[,1], res$Sym.Components[,2],
                  res$Sym.Components[,3],color='blue',
                  labels=TRUE,main='Interscal CFA Data')
sym.scatterplot.ggplot(res$Sym.Components[,1],res$Sym.Components[,2],
                       labels=TRUE)
}
}
\references{
Groenen, P.J.F., Winsberg, S., Rodriguez, O., Diday, E. (2006). I-Scal: Multidimensional
scaling of interval dissimilarities. Computational Statistics and Data Analysis, 51,
360-378.

Rodriguez, O. (2000).
Classification et Modeles Lineaires en Analyse des Donnees Symboliques. Ph.D. Thesis,
Paris IX-Dauphine University
}
\seealso{
sym.interval.pca
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{Interscal}
