/************************************************************************************

   This file is part of SnnsCLib, a fork of the kernel and parts of the gui of 
   the Stuttgart Neural Network Simulator (SNNS), version 4.3.

   The file's original version is part of SNNS 4.3. It's source code can be found at

   http://www.ra.cs.uni-tuebingen.de/SNNS/

   SNNS 4.3 is under the license LGPL v2. We note that source code files of SNNS 4.3 
   state as version "4.2". Base of this fork is SNNS 4.3 with a reverse-applied 
   python patch (see http://developer.berlios.de/projects/snns-dev/).

   SnnsCLib was developed in 2010 by Christoph Bergmeir under supervision of 
   José M. Benítez, both affiliated to DiCITS Lab, Sci2s group, DECSAI, 
   University of Granada

   Changes done to the original code were performed with the objective to
   port it from C to C++ and to encapsulate all code in one class named SnnsCLib.

   Changes in header files mainly include:
   * removed all static keywords
   * moved initializations of variables to the constructor of SnnsCLib

   Changes in cpp code files mainly include:
   * changed file ending from .c to .cpp
   * removed all SNNS internal includes and only include SnnsCLib   
   * static variables within functions were turned into member variables of SnnsCLib
   * function declarations were changed to method declarations, i.e. "SnnsCLib::.."
     was added
   * calls to the function table are now "C++-style", using the "this"-pointer

   License of SnnsCLib:
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.

************************************************************************************/


/*****************************************************************************
  FILE           : $Source: /projects/higgs1/SNNS/CVS/SNNS/kernel/sources/sigmoid.tbl,v $
  SHORTNAME      : 
  SNNS VERSION   : 4.2

  PURPOSE        : SNNS-Kernel: Approximation Table for the Sigmoid Function
  NOTES          :

  AUTHOR         : Niels Mache 
  DATE           : 08.12.91 

  CHANGED BY     : Sven Doering
  RCS VERSION    : $Revision: 2.2 $
  LAST CHANGE    : $Date: 1997/11/12 17:37:07 $

    Copyright (c) 1990-1998  SNNS Group, IPVR, Univ. Stuttgart, Germany

******************************************************************************/

/*
No. of Approx.: 1000
Min. x: -12
Max. x: 12
Minus inf. border: -13
Plus inf. border : 13
Error in [-100,+100]: 7.42501e-05
*/

#define NO_OF_APPROX 1000
#define INDEX_OFFSET 500
#define MINUS_INFINITE_FUNC_VALUE 0.000000000
#define PLUS_INFINITE_FUNC_VALUE 1.000000000
#define SCALE_FACTOR 41.66666667
#define MIN_INDEX -41
#define MAX_INDEX 1041

//static float m[] = {
float m[] = {
3.8838503e-06,  /*  minus infinite border  */
6.218459e-06, 6.3695054e-06, 6.5242207e-06, 6.6826939e-06, 6.8450165e-06, 7.0112818e-06, 7.1815856e-06, 7.356026e-06, 7.5347035e-06, 7.7177211e-06,
7.905184e-06, 8.0972003e-06, 8.2938806e-06, 8.4953382e-06, 8.7016891e-06, 8.9130521e-06, 9.129549e-06, 9.3513045e-06, 9.5784463e-06, 9.8111053e-06,
1.0049415e-05, 1.0293514e-05, 1.0543541e-05, 1.0799642e-05, 1.1061963e-05, 1.1330655e-05, 1.1605874e-05, 1.1887778e-05, 1.2176528e-05, 1.2472293e-05,
1.2775241e-05, 1.3085548e-05, 1.3403391e-05, 1.3728955e-05, 1.4062426e-05, 1.4403997e-05, 1.4753864e-05, 1.511223e-05, 1.5479299e-05, 1.5855284e-05,
1.6240402e-05, 1.6634873e-05, 1.7038926e-05, 1.7452792e-05, 1.7876711e-05, 1.8310926e-05, 1.8755688e-05, 1.9211252e-05, 1.9677881e-05, 2.0155843e-05,
2.0645415e-05, 2.1146878e-05, 2.166052e-05, 2.2186637e-05, 2.2725533e-05, 2.3277518e-05, 2.3842909e-05, 2.4422033e-05, 2.5015222e-05, 2.5622819e-05,
2.6245172e-05, 2.6882642e-05, 2.7535594e-05, 2.8204404e-05, 2.8889458e-05, 2.9591151e-05, 3.0309886e-05, 3.1046077e-05, 3.1800148e-05, 3.2572534e-05,
3.3363678e-05, 3.4174037e-05, 3.5004077e-05, 3.5854276e-05, 3.6725124e-05, 3.7617122e-05, 3.8530783e-05, 3.9466634e-05, 4.0425214e-05, 4.1407074e-05,
4.241278e-05, 4.344291e-05, 4.4498058e-05, 4.5578832e-05, 4.6685852e-05, 4.7819758e-05, 4.8981202e-05, 5.0170851e-05, 5.1389392e-05, 5.2637525e-05,
5.3915969e-05, 5.5225461e-05, 5.6566753e-05, 5.7940618e-05, 5.9347847e-05, 6.078925e-05, 6.2265656e-05, 6.3777916e-05, 6.5326899e-05, 6.6913498e-05,
6.8538625e-05, 7.0203216e-05, 7.190823e-05, 7.3654646e-05, 7.5443471e-05, 7.7275734e-05, 7.9152488e-05, 8.1074816e-05, 8.3043822e-05, 8.5060639e-05,
8.7126429e-05, 8.924238e-05, 9.140971e-05, 9.3629665e-05, 9.5903523e-05, 9.8232592e-05, 0.00010061821, 0.00010306176, 0.00010556463, 0.00010812828,
0.00011075416, 0.00011344381, 0.00011619875, 0.00011902058, 0.00012191093, 0.00012487144, 0.00012790383, 0.00013100984, 0.00013419126, 0.00013744991,
0.00014078768, 0.00014420647, 0.00014770825, 0.00015129505, 0.00015496891, 0.00015873196, 0.00016258636, 0.00016653432, 0.00017057811, 0.00017472006,
0.00017896254, 0.000183308, 0.00018775894, 0.00019231791, 0.00019698753, 0.00020177049, 0.00020666954, 0.00021168748, 0.0002168272, 0.00022209166,
0.00022748389, 0.00023300697, 0.00023866408, 0.00024445847, 0.00025039347, 0.00025647248, 0.00026269901, 0.00026907662, 0.00027560897, 0.00028229982,
0.000289153, 0.00029617246, 0.00030336222, 0.0003107264, 0.00031826924, 0.00032599506, 0.00033390829, 0.00034201348, 0.00035031527, 0.00035881843,
0.00036752784, 0.00037644848, 0.00038558548, 0.00039494407, 0.00040452962, 0.00041434763, 0.00042440372, 0.00043470365, 0.00044525334, 0.00045605881,
0.00046712627, 0.00047846205, 0.00049007265, 0.00050196471, 0.00051414505, 0.00052662064, 0.00053939861, 0.00055248629, 0.00056589116, 0.00057962089,
0.00059368334, 0.00060808654, 0.00062283875, 0.00063794838, 0.00065342409, 0.00066927471, 0.0006855093, 0.00070213714, 0.00071916772, 0.00073661078,
0.00075447627, 0.00077277439, 0.00079151558, 0.00081071055, 0.00083037023, 0.00085050585, 0.00087112888, 0.00089225108, 0.00091388449, 0.00093604144,
0.00095873454, 0.00098197673, 0.0010057812, 0.0010301616, 0.0010551317, 0.0010807057, 0.0011068982, 0.0011337241, 0.0011611986, 0.0011893373,
0.0012181562, 0.0012476716, 0.0012779004, 0.0013088597, 0.0013405669, 0.0013730402, 0.0014062978, 0.0014403587, 0.0014752421, 0.0015109677,
0.0015475558, 0.0015850271, 0.0016234027, 0.0016627043, 0.0017029541, 0.0017441749, 0.0017863898, 0.0018296227, 0.0018738979, 0.0019192405,
0.0019656758, 0.00201323, 0.0020619299, 0.0021118029, 0.0021628768, 0.0022151805, 0.0022687433, 0.0023235951, 0.0023797666, 0.0024372895,
0.0024961957, 0.0025565182, 0.0026182908, 0.002681548, 0.0027463248, 0.0028126576, 0.0028805832, 0.0029501394, 0.0030213649, 0.0030942992,
0.0031689828, 0.0032454572, 0.0033237645, 0.0034039483, 0.0034860528, 0.0035701233, 0.0036562063, 0.0037443491, 0.0038346003, 0.0039270096,
0.0040216275, 0.0041185061, 0.0042176985, 0.0043192589, 0.0044232428, 0.0045297069, 0.0046387094, 0.0047503095, 0.0048645679, 0.0049815467,
0.0051013091, 0.0052239201, 0.0053494459, 0.0054779542, 0.0056095142, 0.0057441966, 0.0058820738, 0.0060232196, 0.0061677096, 0.0063156208,
0.0064670321, 0.006622024, 0.0067806788, 0.0069430805, 0.007109315, 0.0072794699, 0.0074536348, 0.0076319011, 0.0078143622, 0.0080011136,
0.0081922525, 0.0083878784, 0.0085880927, 0.008792999, 0.009002703, 0.0092173127, 0.0094369381, 0.0096616915, 0.0098916877, 0.010127044,
0.010367878, 0.010614314, 0.010866474, 0.011124485, 0.011388476, 0.011658579, 0.011934928, 0.012217659, 0.012506912, 0.012802829,
0.013105554, 0.013415234, 0.013732019, 0.014056063, 0.01438752, 0.01472655, 0.015073312, 0.015427972, 0.015790696, 0.016161654,
0.016541018, 0.016928965, 0.017325672, 0.017731322, 0.018146099, 0.01857019, 0.019003786, 0.01944708, 0.019900269, 0.020363552,
0.020837132, 0.021321213, 0.021816004, 0.022321717, 0.022838565, 0.023366766, 0.023906539, 0.024458107, 0.025021696, 0.025597534,
0.026185852, 0.026786883, 0.027400863, 0.028028032, 0.02866863, 0.029322901, 0.02999109, 0.030673446, 0.031370218, 0.032081658,
0.03280802, 0.033549559, 0.034306534, 0.035079201, 0.035867821, 0.036672654, 0.037493963, 0.03833201, 0.039187058, 0.04005937,
0.04094921, 0.041856842, 0.042782528, 0.04372653, 0.044689111, 0.045670531, 0.046671047, 0.047690918, 0.048730398, 0.049789739,
0.050869192, 0.051969001, 0.053089409, 0.054230656, 0.055392975, 0.056576595, 0.05778174, 0.059008627, 0.060257469, 0.061528469,
0.062821825, 0.064137726, 0.065476352, 0.066837874, 0.068222455, 0.069630246, 0.071061385, 0.072516003, 0.073994215, 0.075496123,
0.077021817, 0.078571372, 0.080144846, 0.081742283, 0.083363708, 0.085009132, 0.086678544, 0.088371914, 0.090089194, 0.091830314,
0.093595181, 0.095383681, 0.097195677, 0.099031006, 0.10088948, 0.10277088, 0.10467498, 0.1066015, 0.10855014, 0.11052059,
0.11251247, 0.11452541, 0.11655898, 0.11861273, 0.12068618, 0.1227788, 0.12489004, 0.12701931, 0.12916597, 0.13132938,
0.13350881, 0.13570354, 0.13791279, 0.14013574, 0.14237153, 0.14461927, 0.14687803, 0.14914683, 0.15142465, 0.15371044,
0.15600312, 0.15830153, 0.16060452, 0.16291087, 0.16521933, 0.16752861, 0.16983738, 0.1721443, 0.17444794, 0.17674689,
0.17903968, 0.18132482, 0.18360076, 0.18586595, 0.1881188, 0.19035771, 0.19258102, 0.19478709, 0.19697422, 0.19914072,
0.20128486, 0.20340492, 0.20549916, 0.20756581, 0.20960312, 0.21160933, 0.21358267, 0.21552138, 0.2174237, 0.21928788,
0.22111218, 0.22289487, 0.22463425, 0.22632863, 0.22797635, 0.22957576, 0.23112526, 0.23262328, 0.23406827, 0.23545874,
0.23679324, 0.23807035, 0.23928871, 0.24044703, 0.24154403, 0.24257854, 0.24354941, 0.24445557, 0.24529602, 0.24606982,
0.2467761, 0.24741406, 0.24798298, 0.24848222, 0.24891121, 0.24926945, 0.24955654, 0.24977214, 0.24991602, 0.249988,
0.249988, 0.24991602, 0.24977214, 0.24955654, 0.24926945, 0.24891121, 0.24848222, 0.24798298, 0.24741406, 0.2467761,
0.24606982, 0.24529602, 0.24445557, 0.24354941, 0.24257854, 0.24154403, 0.24044703, 0.23928871, 0.23807035, 0.23679324,
0.23545874, 0.23406827, 0.23262328, 0.23112526, 0.22957576, 0.22797635, 0.22632863, 0.22463425, 0.22289487, 0.22111218,
0.21928788, 0.2174237, 0.21552138, 0.21358267, 0.21160933, 0.20960312, 0.20756581, 0.20549916, 0.20340492, 0.20128486,
0.19914072, 0.19697422, 0.19478709, 0.19258102, 0.19035771, 0.1881188, 0.18586595, 0.18360076, 0.18132482, 0.17903968,
0.17674689, 0.17444794, 0.1721443, 0.16983738, 0.16752861, 0.16521933, 0.16291087, 0.16060452, 0.15830153, 0.15600312,
0.15371044, 0.15142465, 0.14914683, 0.14687803, 0.14461927, 0.14237153, 0.14013574, 0.13791279, 0.13570354, 0.13350881,
0.13132938, 0.12916597, 0.12701931, 0.12489004, 0.1227788, 0.12068618, 0.11861273, 0.11655898, 0.11452541, 0.11251247,
0.11052059, 0.10855014, 0.1066015, 0.10467498, 0.10277088, 0.10088948, 0.099031006, 0.097195677, 0.095383681, 0.093595181,
0.091830314, 0.090089194, 0.088371914, 0.086678544, 0.085009132, 0.083363708, 0.081742283, 0.080144846, 0.078571372, 0.077021817,
0.075496123, 0.073994215, 0.072516003, 0.071061385, 0.069630246, 0.068222455, 0.066837874, 0.065476352, 0.064137726, 0.062821825,
0.061528469, 0.060257469, 0.059008627, 0.05778174, 0.056576595, 0.055392975, 0.054230656, 0.053089409, 0.051969001, 0.050869192,
0.049789739, 0.048730398, 0.047690918, 0.046671047, 0.045670531, 0.044689111, 0.04372653, 0.042782528, 0.041856842, 0.04094921,
0.04005937, 0.039187058, 0.03833201, 0.037493963, 0.036672654, 0.035867821, 0.035079201, 0.034306534, 0.033549559, 0.03280802,
0.032081658, 0.031370218, 0.030673446, 0.02999109, 0.029322901, 0.02866863, 0.028028032, 0.027400863, 0.026786883, 0.026185852,
0.025597534, 0.025021696, 0.024458107, 0.023906539, 0.023366766, 0.022838565, 0.022321717, 0.021816004, 0.021321213, 0.020837132,
0.020363552, 0.019900269, 0.01944708, 0.019003786, 0.01857019, 0.018146099, 0.017731322, 0.017325672, 0.016928965, 0.016541018,
0.016161654, 0.015790696, 0.015427972, 0.015073312, 0.01472655, 0.01438752, 0.014056063, 0.013732019, 0.013415234, 0.013105554,
0.012802829, 0.012506912, 0.012217659, 0.011934928, 0.011658579, 0.011388476, 0.011124485, 0.010866474, 0.010614314, 0.010367878,
0.010127044, 0.0098916877, 0.0096616915, 0.0094369381, 0.0092173127, 0.009002703, 0.008792999, 0.0085880927, 0.0083878784, 0.0081922525,
0.0080011136, 0.0078143622, 0.0076319011, 0.0074536348, 0.0072794699, 0.007109315, 0.0069430805, 0.0067806788, 0.006622024, 0.0064670321,
0.0063156208, 0.0061677096, 0.0060232196, 0.0058820738, 0.0057441966, 0.0056095142, 0.0054779542, 0.0053494459, 0.0052239201, 0.0051013091,
0.0049815467, 0.0048645679, 0.0047503095, 0.0046387094, 0.0045297069, 0.0044232428, 0.0043192589, 0.0042176985, 0.0041185061, 0.0040216275,
0.0039270096, 0.0038346003, 0.0037443491, 0.0036562063, 0.0035701233, 0.0034860528, 0.0034039483, 0.0033237645, 0.0032454572, 0.0031689828,
0.0030942992, 0.0030213649, 0.0029501394, 0.0028805832, 0.0028126576, 0.0027463248, 0.002681548, 0.0026182908, 0.0025565182, 0.0024961957,
0.0024372895, 0.0023797666, 0.0023235951, 0.0022687433, 0.0022151805, 0.0021628768, 0.0021118029, 0.0020619299, 0.00201323, 0.0019656758,
0.0019192405, 0.0018738979, 0.0018296227, 0.0017863898, 0.0017441749, 0.0017029541, 0.0016627043, 0.0016234027, 0.0015850271, 0.0015475558,
0.0015109677, 0.0014752421, 0.0014403587, 0.0014062978, 0.0013730402, 0.0013405669, 0.0013088597, 0.0012779004, 0.0012476716, 0.0012181562,
0.0011893373, 0.0011611986, 0.0011337241, 0.0011068982, 0.0010807057, 0.0010551317, 0.0010301616, 0.0010057812, 0.00098197673, 0.00095873454,
0.00093604144, 0.00091388449, 0.00089225108, 0.00087112888, 0.00085050585, 0.00083037023, 0.00081071055, 0.00079151558, 0.00077277439, 0.00075447627,
0.00073661078, 0.00071916772, 0.00070213714, 0.0006855093, 0.00066927471, 0.00065342409, 0.00063794838, 0.00062283875, 0.00060808654, 0.00059368334,
0.00057962089, 0.00056589116, 0.00055248629, 0.00053939861, 0.00052662064, 0.00051414505, 0.00050196471, 0.00049007265, 0.00047846205, 0.00046712627,
0.00045605881, 0.00044525334, 0.00043470365, 0.00042440372, 0.00041434763, 0.00040452962, 0.00039494407, 0.00038558548, 0.00037644848, 0.00036752784,
0.00035881843, 0.00035031527, 0.00034201348, 0.00033390829, 0.00032599506, 0.00031826924, 0.0003107264, 0.00030336222, 0.00029617246, 0.000289153,
0.00028229982, 0.00027560897, 0.00026907662, 0.00026269901, 0.00025647248, 0.00025039347, 0.00024445847, 0.00023866408, 0.00023300697, 0.00022748389,
0.00022209166, 0.0002168272, 0.00021168748, 0.00020666954, 0.00020177049, 0.00019698753, 0.00019231791, 0.00018775894, 0.000183308, 0.00017896254,
0.00017472006, 0.00017057811, 0.00016653432, 0.00016258636, 0.00015873196, 0.00015496891, 0.00015129505, 0.00014770825, 0.00014420647, 0.00014078768,
0.00013744991, 0.00013419126, 0.00013100984, 0.00012790383, 0.00012487144, 0.00012191093, 0.00011902058, 0.00011619875, 0.00011344381, 0.00011075416,
0.00010812828, 0.00010556463, 0.00010306176, 0.00010061821, 9.8232592e-05, 9.5903523e-05, 9.3629665e-05, 9.140971e-05, 8.924238e-05, 8.7126429e-05,
8.5060639e-05, 8.3043822e-05, 8.1074816e-05, 7.9152488e-05, 7.7275734e-05, 7.5443471e-05, 7.3654646e-05, 7.190823e-05, 7.0203216e-05, 6.8538625e-05,
6.6913498e-05, 6.5326899e-05, 6.3777916e-05, 6.2265656e-05, 6.078925e-05, 5.9347847e-05, 5.7940618e-05, 5.6566753e-05, 5.5225461e-05, 5.3915969e-05,
5.2637525e-05, 5.1389392e-05, 5.0170851e-05, 4.8981202e-05, 4.7819758e-05, 4.6685852e-05, 4.5578832e-05, 4.4498058e-05, 4.344291e-05, 4.241278e-05,
4.1407074e-05, 4.0425214e-05, 3.9466634e-05, 3.8530783e-05, 3.7617122e-05, 3.6725124e-05, 3.5854276e-05, 3.5004077e-05, 3.4174037e-05, 3.3363678e-05,
3.2572534e-05, 3.1800148e-05, 3.1046077e-05, 3.0309886e-05, 2.9591151e-05, 2.8889458e-05, 2.8204404e-05, 2.7535594e-05, 2.6882642e-05, 2.6245172e-05,
2.5622819e-05, 2.5015222e-05, 2.4422033e-05, 2.3842909e-05, 2.3277518e-05, 2.2725533e-05, 2.2186637e-05, 2.166052e-05, 2.1146878e-05, 2.0645415e-05,
2.0155843e-05, 1.9677881e-05, 1.9211252e-05, 1.8755688e-05, 1.8310926e-05, 1.7876711e-05, 1.7452792e-05, 1.7038926e-05, 1.6634873e-05, 1.6240402e-05,
1.5855284e-05, 1.5479299e-05, 1.511223e-05, 1.4753864e-05, 1.4403997e-05, 1.4062426e-05, 1.3728955e-05, 1.3403391e-05, 1.3085548e-05, 1.2775241e-05,
1.2472293e-05, 1.2176528e-05, 1.1887778e-05, 1.1605874e-05, 1.1330655e-05, 1.1061963e-05, 1.0799642e-05, 1.0543541e-05, 1.0293514e-05, 1.0049415e-05,
9.8111053e-06, 9.5784463e-06, 9.3513045e-06, 9.129549e-06, 8.9130521e-06, 8.7016891e-06, 8.4953382e-06, 8.2938806e-06, 8.0972003e-06, 7.905184e-06,
7.7177211e-06, 7.5347035e-06, 7.356026e-06, 7.1815856e-06, 7.0112818e-06, 6.8450165e-06, 6.6826939e-06, 6.5242207e-06, 6.3695054e-06, 
3.8838503e-06  };  /*  plus infinite border  */

//static float b[] = {
float b[] = {
5.2750378e-05,  /*  minus infinite border  */
8.0765682e-05, 8.2574614e-05, 8.4423771e-05, 8.631404e-05, 8.8246328e-05, 9.022156e-05, 9.2240682e-05, 9.4304661e-05, 9.6414485e-05, 9.8571163e-05,
0.00010077573, 0.00010302923, 0.00010533275, 0.00010768739, 0.00011009426, 0.00011255453, 0.00011506936, 0.00011763995, 0.00012026752, 0.00012295334,
0.00012569867, 0.00012850483, 0.00013137314, 0.00013430498, 0.00013730173, 0.00014036483, 0.00014349572, 0.00014669589, 0.00014996686, 0.00015331018,
0.00015672743, 0.00016022024, 0.00016379026, 0.00016743918, 0.00017116872, 0.00017498066, 0.00017887678, 0.00018285893, 0.000186929, 0.0001910889,
0.0001953406, 0.00019968609, 0.00020412744, 0.00020866673, 0.00021330609, 0.00021804772, 0.00022289384, 0.00022784674, 0.00023290873, 0.0002380822,
0.00024336957, 0.00024877333, 0.00025429601, 0.0002599402, 0.00026570854, 0.00027160374, 0.00027762855, 0.00028378579, 0.00029007834, 0.00029650914,
0.0003030812, 0.00030979758, 0.00031666141, 0.00032367589, 0.0003308443, 0.00033816997, 0.00034565631, 0.00035330681, 0.00036112502, 0.00036911458,
0.00037727918, 0.00038562264, 0.00039414881, 0.00040286165, 0.0004117652, 0.00042086358, 0.000430161, 0.00043966176, 0.00044937025, 0.00045929097,
0.00046942848, 0.00047978747, 0.00049037272, 0.0005011891, 0.00051224159, 0.0005235353, 0.0005350754, 0.0005468672, 0.00055891613, 0.00057122772,
0.00058380761, 0.00059666158, 0.00060979551, 0.00062321543, 0.00063692747, 0.0006509379, 0.00066525314, 0.00067987971, 0.0006948243, 0.00071009373,
0.00072569495, 0.00074163508, 0.00075792136, 0.00077456122, 0.00079156221, 0.00080893206, 0.00082667866, 0.00084481005, 0.00086333445, 0.00088226027,
0.00090159606, 0.00092135058, 0.00094153275, 0.0009621517, 0.00098321672, 0.0010047373, 0.0010267232, 0.0010491842, 0.0010721306, 0.0010955726,
0.0011195207, 0.0011439857, 0.0011689785, 0.0011945105, 0.0012205929, 0.0012472376, 0.0012744563, 0.0013022613, 0.001330665, 0.00135968,
0.0013893194, 0.0014195962, 0.001450524, 0.0014821164, 0.0015143877, 0.001547352, 0.001581024, 0.0016154186, 0.001650551, 0.0016864369,
0.001723092, 0.0017605325, 0.0017987749, 0.0018378362, 0.0018777334, 0.0019184842, 0.0019601065, 0.0020026185, 0.0020460389, 0.0020903868,
0.0021356814, 0.0021819427, 0.0022291909, 0.0022774466, 0.0023267309, 0.0023770651, 0.0024284713, 0.0024809718, 0.0025345893, 0.0025893472,
0.0026452692, 0.0027023795, 0.0027607028, 0.0028202643, 0.0028810898, 0.0029432054, 0.0030066378, 0.0030714145, 0.0031375632, 0.0032051123,
0.0032740908, 0.0033445282, 0.0034164546, 0.0034899009, 0.0035648982, 0.0036414787, 0.0037196748, 0.0037995199, 0.0038810479, 0.0039642932,
0.0040492913, 0.0041360781, 0.0042246902, 0.004315165, 0.0044075406, 0.0045018561, 0.0045981509, 0.0046964655, 0.0047968412, 0.0048993199,
0.0050039445, 0.0051107587, 0.005219807, 0.0053311348, 0.0054447884, 0.0055608149, 0.0056792625, 0.0058001801, 0.0059236178, 0.0060496264,
0.006178258, 0.0063095653, 0.0064436023, 0.006580424, 0.0067200864, 0.0068626466, 0.0070081627, 0.007156694, 0.007308301, 0.0074630451,
0.0076209891, 0.0077821969, 0.0079467335, 0.0081146654, 0.0082860601, 0.0084609865, 0.0086395146, 0.0088217159, 0.0090076632, 0.0091974307,
0.0093910937, 0.0095887293, 0.0097904158, 0.0099962328, 0.010206262, 0.010420585, 0.010639287, 0.010862454, 0.011090173, 0.011322532,
0.011559624, 0.011801538, 0.01204837, 0.012300215, 0.01255717, 0.012819333, 0.013086807, 0.013359693, 0.013638096, 0.013922121,
0.014211878, 0.014507475, 0.014809025, 0.015116641, 0.01543044, 0.015750538, 0.016077057, 0.016410117, 0.016749842, 0.01709636,
0.017449797, 0.017810285, 0.018177955, 0.018552944, 0.018935386, 0.019325423, 0.019723195, 0.020128847, 0.020542525, 0.020964377,
0.021394554, 0.021833211, 0.022280503, 0.022736588, 0.023201628, 0.023675786, 0.024159228, 0.024652122, 0.025154641, 0.025666958,
0.026189249, 0.026721694, 0.027264474, 0.027817776, 0.028381784, 0.028956691, 0.029542688, 0.030139972, 0.03074874, 0.031369196,
0.032001542, 0.032645985, 0.033302736, 0.033972007, 0.034654014, 0.035348975, 0.036057112, 0.03677865, 0.037513815, 0.038262837,
0.03902595, 0.03980339, 0.040595394, 0.041402206, 0.042224069, 0.043061231, 0.043913943, 0.044782456, 0.045667028, 0.046567916,
0.047485383, 0.048419692, 0.049371111, 0.050339908, 0.051326356, 0.052330729, 0.053353304, 0.054394362, 0.055454185, 0.056533056,
0.057631262, 0.058749093, 0.059886839, 0.061044793, 0.06222325, 0.063422508, 0.064642864, 0.06588462, 0.067148077, 0.068433539,
0.06974131, 0.071071696, 0.072425004, 0.073801541, 0.075201617, 0.07662554, 0.078073621, 0.079546168, 0.081043493, 0.082565904,
0.08411371, 0.085687222, 0.087286747, 0.088912592, 0.090565062, 0.092244463, 0.093951096, 0.095685263, 0.097447262, 0.099237387,
0.10105593, 0.10290319, 0.10477944, 0.10668496, 0.10862004, 0.11058495, 0.11257995, 0.11460531, 0.11666128, 0.11874812,
0.12086606, 0.12301535, 0.1251962, 0.12740886, 0.12965351, 0.13193037, 0.13423964, 0.13658148, 0.13895608, 0.14136359,
0.14380417, 0.14627795, 0.14878504, 0.15132557, 0.15389963, 0.15650729, 0.15914862, 0.16182366, 0.16453246, 0.16727501,
0.17005131, 0.17286134, 0.17570504, 0.17858236, 0.18149321, 0.18443746, 0.187415, 0.19042566, 0.19346926, 0.19654559,
0.19965441, 0.20279546, 0.20596846, 0.20917308, 0.21240898, 0.21567577, 0.21897304, 0.22230036, 0.22565725, 0.22904319,
0.23245765, 0.23590005, 0.23936977, 0.24286616, 0.24638853, 0.24993616, 0.25350829, 0.2571041, 0.26072276, 0.26436339,
0.26802506, 0.2717068, 0.27540761, 0.27912644, 0.28286221, 0.28661377, 0.29037997, 0.29415957, 0.29795132, 0.30175393,
0.30556604, 0.30938628, 0.31321321, 0.31704538, 0.32088127, 0.32471934, 0.32855799, 0.33239562, 0.33623055, 0.34006109,
0.34388551, 0.34770204, 0.35150889, 0.35530422, 0.35908619, 0.36285291, 0.36660247, 0.37033294, 0.37404238, 0.37772882,
0.38139027, 0.38502475, 0.38863024, 0.39220474, 0.39574624, 0.39925272, 0.40272217, 0.40615259, 0.40954199, 0.41288839,
0.41618984, 0.4194444, 0.42265015, 0.42580524, 0.42890781, 0.43195606, 0.43494823, 0.43788262, 0.44075757, 0.44357149,
0.44632284, 0.44901015, 0.45163204, 0.45418717, 0.45667432, 0.45909234, 0.46144016, 0.46371682, 0.46592145, 0.46805328,
0.47011166, 0.47209604, 0.47400598, 0.47584117, 0.47760141, 0.47928662, 0.48089687, 0.48243232, 0.4838933, 0.48528025,
0.48659375, 0.4878345, 0.48900337, 0.49010133, 0.4911295, 0.49208915, 0.49298166, 0.49380857, 0.49457152, 0.49527232,
0.49591288, 0.49649524, 0.49702158, 0.49749417, 0.49791542, 0.49828784, 0.49861405, 0.49889678, 0.49913882, 0.49934311,
0.49951261, 0.49965041, 0.49975965, 0.49984352, 0.49990529, 0.49994828, 0.49997584, 0.49999137, 0.49999827, 0.5,
0.5, 0.50000173, 0.50000863, 0.50002416, 0.50005172, 0.50009471, 0.50015648, 0.50024035, 0.50034959, 0.50048739,
0.50065689, 0.50086118, 0.50110322, 0.50138595, 0.50171216, 0.50208458, 0.50250583, 0.50297842, 0.50350476, 0.50408712,
0.50472768, 0.50542848, 0.50619143, 0.50701834, 0.50791085, 0.5088705, 0.50989867, 0.51099663, 0.51216549, 0.51340625,
0.51471974, 0.51610669, 0.51756768, 0.51910313, 0.52071338, 0.52239859, 0.52415883, 0.52599402, 0.52790396, 0.52988834,
0.53194672, 0.53407855, 0.53628318, 0.53855984, 0.54090766, 0.54332568, 0.54581283, 0.54836796, 0.55098985, 0.55367716,
0.55642851, 0.55924243, 0.56211738, 0.56505177, 0.56804394, 0.57109219, 0.57419476, 0.57734984, 0.5805556, 0.58381016,
0.58711161, 0.59045801, 0.59384741, 0.59727783, 0.60074728, 0.60425376, 0.60779526, 0.61136976, 0.61497525, 0.61860972,
0.62227118, 0.62595762, 0.62966706, 0.63339753, 0.63714709, 0.64091381, 0.64469578, 0.64849111, 0.65229796, 0.65611449,
0.65993891, 0.66376945, 0.66760438, 0.671442, 0.67528066, 0.67911873, 0.68295462, 0.68678678, 0.69061372, 0.69443396,
0.69824607, 0.70204868, 0.70584043, 0.70962003, 0.71338622, 0.71713779, 0.72087356, 0.72459239, 0.7282932, 0.73197494,
0.73563661, 0.73927723, 0.7428959, 0.74649171, 0.75006384, 0.75361147, 0.75713384, 0.76063023, 0.76409995, 0.76754235,
0.7709568, 0.77434275, 0.77769964, 0.78102696, 0.78432423, 0.78759102, 0.79082692, 0.79403154, 0.79720454, 0.80034559,
0.80345441, 0.80653074, 0.80957434, 0.812585, 0.81556253, 0.81850679, 0.82141764, 0.82429496, 0.82713866, 0.82994869,
0.83272499, 0.83546754, 0.83817633, 0.84085138, 0.84349271, 0.84610037, 0.84867442, 0.85121496, 0.85372205, 0.85619583,
0.85863641, 0.86104392, 0.86341852, 0.86576036, 0.86806962, 0.87034649, 0.87259114, 0.87480379, 0.87698465, 0.87913394,
0.88125188, 0.88333872, 0.88539469, 0.88742005, 0.88941505, 0.89137996, 0.89331504, 0.89522056, 0.89709681, 0.89894407,
0.90076261, 0.90255274, 0.90431474, 0.9060489, 0.90775554, 0.90943494, 0.91108741, 0.91271325, 0.91431278, 0.91588629,
0.9174341, 0.91895651, 0.92045383, 0.92192638, 0.92337446, 0.92479838, 0.92619846, 0.927575, 0.9289283, 0.93025869,
0.93156646, 0.93285192, 0.93411538, 0.93535714, 0.93657749, 0.93777675, 0.93895521, 0.94011316, 0.94125091, 0.94236874,
0.94346694, 0.94454582, 0.94560564, 0.9466467, 0.94766927, 0.94867364, 0.94966009, 0.95062889, 0.95158031, 0.95251462,
0.95343208, 0.95433297, 0.95521754, 0.95608606, 0.95693877, 0.95777593, 0.95859779, 0.9594046, 0.96019661, 0.96097405,
0.96173716, 0.96248618, 0.96322135, 0.96394289, 0.96465102, 0.96534599, 0.96602799, 0.96669726, 0.96735402, 0.96799846,
0.9686308, 0.96925126, 0.96986003, 0.97045731, 0.97104331, 0.97161822, 0.97218222, 0.97273552, 0.97327831, 0.97381075,
0.97433304, 0.97484536, 0.97534788, 0.97584077, 0.97632421, 0.97679837, 0.97726341, 0.9777195, 0.97816679, 0.97860544,
0.97903562, 0.97945748, 0.97987115, 0.9802768, 0.98067458, 0.98106461, 0.98144706, 0.98182204, 0.98218972, 0.9825502,
0.98290364, 0.98325016, 0.98358988, 0.98392294, 0.98424946, 0.98456956, 0.98488336, 0.98519098, 0.98549252, 0.98578812,
0.98607788, 0.9863619, 0.98664031, 0.98691319, 0.98718067, 0.98744283, 0.98769978, 0.98795163, 0.98819846, 0.98844038,
0.98867747, 0.98890983, 0.98913754, 0.98936071, 0.98957941, 0.98979374, 0.99000377, 0.99020958, 0.99041127, 0.99060891,
0.99080257, 0.99099234, 0.99117828, 0.99136048, 0.99153901, 0.99171394, 0.99188533, 0.99205327, 0.9922178, 0.99237901,
0.99253695, 0.9926917, 0.9928433, 0.99299184, 0.99313735, 0.99327991, 0.99341958, 0.9935564, 0.99369043, 0.99382174,
0.99395037, 0.99407638, 0.99419982, 0.99432074, 0.99443918, 0.99455521, 0.99466886, 0.99478019, 0.99488924, 0.99499606,
0.99510068, 0.99520316, 0.99530353, 0.99540185, 0.99549814, 0.99559246, 0.99568484, 0.99577531, 0.99586392, 0.99595071,
0.99603571, 0.99611895, 0.99620048, 0.99628032, 0.99635852, 0.9964351, 0.9965101, 0.99658354, 0.99665547, 0.99672591,
0.99679489, 0.99686244, 0.99692858, 0.99699336, 0.99705679, 0.99711891, 0.99717974, 0.9972393, 0.99729762, 0.99735473,
0.99741065, 0.99746541, 0.99751903, 0.99757153, 0.99762293, 0.99767327, 0.99772255, 0.99777081, 0.99781806, 0.99786432,
0.99790961, 0.99795396, 0.99799738, 0.99803989, 0.99808152, 0.99812227, 0.99816216, 0.99820122, 0.99823947, 0.99827691,
0.99831356, 0.99834945, 0.99838458, 0.99841898, 0.99845265, 0.99848561, 0.99851788, 0.99854948, 0.9985804, 0.99861068,
0.99864032, 0.99866933, 0.99869774, 0.99872554, 0.99875276, 0.99877941, 0.99880549, 0.99883102, 0.99885601, 0.99888048,
0.99890443, 0.99892787, 0.99895082, 0.99897328, 0.99899526, 0.99901678, 0.99903785, 0.99905847, 0.99907865, 0.9990984,
0.99911774, 0.99913666, 0.99915519, 0.99917332, 0.99919107, 0.99920844, 0.99922544, 0.99924208, 0.99925836, 0.9992743,
0.99928991, 0.99930518, 0.99932012, 0.99933475, 0.99934906, 0.99936307, 0.99937678, 0.9993902, 0.99940334, 0.99941619,
0.99942877, 0.99944108, 0.99945313, 0.99946492, 0.99947646, 0.99948776, 0.99949881, 0.99950963, 0.99952021, 0.99953057,
0.99954071, 0.99955063, 0.99956034, 0.99956984, 0.99957914, 0.99958823, 0.99959714, 0.99960585, 0.99961438, 0.99962272,
0.99963088, 0.99963887, 0.99964669, 0.99965434, 0.99966183, 0.99966916, 0.99967632, 0.99968334, 0.9996902, 0.99969692,
0.99970349, 0.99970992, 0.99971621, 0.99972237, 0.9997284, 0.99973429, 0.99974006, 0.9997457, 0.99975123, 0.99975663,
0.99976192, 0.99976709, 0.99977215, 0.99977711, 0.99978195, 0.99978669, 0.99979133, 0.99979587, 0.99980031, 0.99980466,
0.99980891, 0.99981307, 0.99981714, 0.99982112, 0.99982502, 0.99982883, 0.99983256, 0.99983621, 0.99983978, 0.99984327,
0.99984669, 0.99985003, 0.9998533, 0.9998565, 0.99985964, 0.9998627, 0.9998657, 0.99986863, 0.9998715, 0.9998743,
0.99987705, 0.99987973, 0.99988236, 0.99988493, 0.99988744, 0.9998899, 0.99989231, 0.99989467, 0.99989697, 0.99989922,
0.99990143, 0.99990358, 0.9999057, 0.99990776, 0.99990978, 0.99991175, 0.99991368, 0.99991558, 0.99991742, 
0.99994725  };  /*  plus infinite border  */
