% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ManageVariables.R
\name{ManageVariables}
\alias{ManageVariables}
\title{GUI: Variable Manager}
\usage{
ManageVariables(cols, vars, query, changelog, parent = NULL)
}
\arguments{
\item{cols}{list.
See \sQuote{Value} section}

\item{vars}{list.
See \sQuote{Value} section}

\item{query}{character.
See \sQuote{Value} section}

\item{changelog}{data.frame.
See \sQuote{Value} section}

\item{parent}{tkwin.
\acronym{GUI} parent window}
}
\value{
Returns an object of class list with components \code{cols} and \code{vars}.
  The \code{cols} object is a list whose length is equal to the current number of data variables.
  Each component in \code{cols} is linked to a specific variable,
  and contains the following components:
    \item{name}{variable name}
    \item{format}{conversion specification format (optional)}
    \item{id}{unique identifier that is created from \code{name}.}
    \item{fun}{expression evaluated when computing the variables vector of values.}
    \item{index}{variable's component index number in the \code{data.raw} data table, see \code{\link{ImportText}}.
      Only required for variables directly linked to data columns in \code{data.raw}.}
    \item{class}{data class of the vector object.}
    \item{summary}{summary of the variable's descriptive statistics (see \code{\link{summary}}).}
    \item{comments}{user comments}
  The \code{vars} object is a list with components:
    \item{x, y, z, sort.on}{the index number of the corresponding state variable in \code{cols}.
      These indexes are updated to reflect the removal and (or) reordering of variables in \code{cols}.}
    \item{query}{if required, variable names are updated.}
    \item{changelog}{if required, names in the \code{variable} component are updated.}
}
\description{
A graphical user interface (\acronym{GUI}) for managing variables in the data table.
}
\details{
This \acronym{GUI} lets you:
  (1) specify the names and format of variables;
  (2) add new variables based on user defined functions, see \code{\link{EditFunction}};
  (3) display data in a spreadsheet, see \code{\link{EditData}}; and
  (4) remove and (or) reorder variables in the data table.
}
\examples{
\dontrun{
  Data(replace.all = obj)
  ManageVariables(obj$cols, obj$vars, obj$query, obj$changelog)
}

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{misc}
