% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00roxygen.R, R/methods.R
\name{ADconstruct}
\alias{ADconstruct}
\alias{diag,advector,ANY,ANY-method}
\alias{matrix,advector-method}
\title{AD aware numeric constructors}
\usage{
\S4method{diag}{advector,ANY,ANY}(x, nrow, ncol)

\S4method{matrix}{advector}(data = NA, nrow = 1, ncol = 1, byrow = FALSE, dimnames = NULL)
}
\arguments{
\item{x}{As \link[base]{diag}}

\item{nrow}{As \link[base]{matrix}}

\item{ncol}{As \link[base]{matrix}}

\item{data}{As \link[base]{matrix}}

\item{byrow}{As \link[base]{matrix}}

\item{dimnames}{As \link[base]{matrix}}
}
\value{
Object of class \code{"advector"} with a dimension attribute.
}
\description{
These base constructors have been extended to keep the AD class attribute of the data argument.
}
\section{Functions}{
\itemize{
\item \code{diag(x = advector, nrow = ANY, ncol = ANY)}: Equivalent of \link[base]{diag}

\item \code{matrix(advector)}: Equivalent of \link[base]{matrix}

}}
\examples{
func <- function(x) {
  M <- matrix(x, 2, 2)
  print(class(M))
  D <- diag(x)
  print(class(D))
  0
}
invisible(func(1:4))            ## 'matrix' 'array'
invisible(MakeTape(func, 1:4))  ## 'advector'
}
