% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RTSA_plot.R
\name{plot.RTSA}
\alias{plot.RTSA}
\title{plot.RTSA}
\usage{
\method{plot}{RTSA}(x, model = "random", type = "classic", theme = "classic", sign = 1, ...)
}
\arguments{
\item{x}{RTSA object}

\item{model}{Whether a fixed- or random-effects meta-analysis should be used. Defaults to random.}

\item{type}{Should Z-scores (classic) or outcome values (outcome) be plotted.}

\item{theme}{Whether the theme is traditional TSA (classic) or modern (modern)}

\item{sign}{Whether the y-axis runs from -Inf to Inf, or Inf to -Inf.}

\item{...}{Other arguments to plot.RTSA}
}
\value{
Plot. Either a plot for two sided testing or one-sided
}
\description{
plot.RTSA
}
\examples{
data(perioOxy)
outRTSA <- RTSA(type = "analysis", data = perioOxy, outcome = "RR", mc = 0.8,
 side = 2, alpha = 0.05, beta = 0.2, fixed = FALSE, es_alpha = "esOF")
plot(x = outRTSA)

}
