\name{predict.MVA.cv}
\alias{predict.MVA.cv}
\alias{predict.MVA.cmv}
\title{
Predict method for cross-validated submodels
}
\description{
Predicts response based on submodels generated by cross (model) validation. For regression models (PLSR and CPPLS), the predicted value is given with its confidence interval. For discriminant analyses, the predicted class is given with its probability (computed from the values predicted by all submodels).
}
\usage{

\method{predict}{MVA.cv}(object, newdata, conf.level = 0.95, type.DA = c("max", "all"),
   crit.DA = c("plug-in", "predictive", "debiased"), ...)
\method{predict}{MVA.cmv}(object, newdata, conf.level = 0.95, type.DA = c("max", "all"),
  crit.DA = c("plug-in", "predictive", "debiased"), ...)

}
\arguments{
  \item{object}{
object of class inheriting from \code{"MVA.cv"} or \code{"MVA.cmv"}.
}
  \item{newdata}{
vector, matrix or data frame giving new individuals (one row per individual).
}
  \item{conf.level}{
confidence level for prediction of a quantitative response.
}
  \item{type.DA}{
for discriminant analyses, should the probability of the most probable class be given (\code{"max"}, the default) or the probability of each class (\code{"all"})?
}
  \item{crit.DA}{
criterion used to predict class membership when a LDA or QDA is used. See \code{\link[MASS]{predict.lda}}.
}
  \item{\dots}{
further arguments to be passed to or from other methods.
}
}
\author{
Maxime Herv <maxime.herve@univ-rennes1.fr>
}
\seealso{
\code{\link[RVAideMemoire]{MVA.cv}}, \code{\link[RVAideMemoire]{MVA.cmv}}
}
