% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_deps.R
\name{p_deps}
\alias{p_deps}
\alias{p_depsrev}
\alias{p_network}
\title{Dependencies and Reverse Dependencies of Packages}
\usage{
p_deps(..., char = NULL, which = "DIL", recursive = FALSE,
  reverse = FALSE, verbose = getOption("verbose"),
  crandb = get("crandb", envir = .GlobalEnv))

p_depsrev(..., char = NULL, which = "DIL", recursive = FALSE,
  reverse = FALSE, verbose = getOption("verbose"),
  crandb = get("crandb", envir = .GlobalEnv))

p_network(..., char = NULL, which = "DIL", reverse = FALSE,
  exclpkgs = TRUE, crandb = get("crandb", envir = .GlobalEnv))
}
\arguments{
\item{...}{any format recognized by \code{\link{cnsc}}, excluding list.
A package or a vector of packages listed in \code{crandb} or in
\code{installed.packages()}.}

\item{char}{(name to) a character vector. Use this argument if 
\code{...} fails or if you call the function from another function. 
If used, argument \code{...} is ignored.}

\item{which}{character vector. A sub-vector of 
\code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}. 
The short forms "D", "I", "L", "S", "N", "DL", "DI", "DIL", "DILS", 
"DILN", "DILSN", "SN" are accepted. "N" is for "Enhances" as the 
single letter "E" is used by R as a shortcut to EXPR, a reserved word.}

\item{recursive}{logical. Search for (reverse) dependencies of (reverse) dependencies.}

\item{reverse}{logical. Search for reverse dependencies.}

\item{verbose}{logical. Returns additional information about the search.}

\item{crandb}{data.frame \code{crandb}. Also accepted is \code{NULL} which will 
search in the local \code{installed.packages()}. This later form
allows (private) packages that are not listed in \code{crandb}.}

\item{exclpkgs}{logical or character vector. \code{TRUE} excludes 
from the network of nodes and links the dependencies
\code{c("graphics", "grDevices", "methods", "stats", "tools", "utils")}.
\code{FALSE} includes them. 
You can provide your own vector of packages to exclude them 
from the network of nodes and links.}
}
\description{
\code{p_deps} returns the (reverse) dependencies of a (vector of) package(s). 
It is a wrapper of the \code{tools::package_dependencies} function. A warning is issued 
for packages that are not in \code{crandb + .libPaths()} (for instance in BioConductor).

\code{p_depsrev} returns the reverse dependencies.

\code{p_network} returns the package dependencies as a network of nodes and links. 
It is called by \code{\link{n_graphF}} and \code{\link{n_graphS}}.
}
\examples{
## In real life, download crandb from CRAN or load it from your directory 
## with functions crandb_down() or crandb_load(). 
## In this example, we use a small file.
crandb_load(system.file("data", "zcrandb.rda", package = "RWsearch"))

p_deps(canprot, FatTailsR) 
p_deps(canprot, FatTailsR, recursive = TRUE)
p_deps(canprot, FatTailsR, recursive = TRUE, which = "DIL")
p_deps(actuar, reverse = TRUE, which = "DILSN")

p_network(canprot, FatTailsR, exclpkgs = FALSE)

}
