% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{inspectKNN}
\alias{inspectKNN}
\title{Function for inspecting pruned k-nearest neighbourhoods}
\usage{
inspectKNN(
  i,
  expData,
  res,
  cl,
  object = NULL,
  nb = res$pars$nb,
  pvalue = 0.01,
  backModel = NULL,
  alpha = res$alpha[i],
  plotSymbol = FALSE,
  id = NULL,
  degree = 2,
  span = 0.75,
  cv = FALSE,
  ...
)
}
\arguments{
\item{i}{Either integer column index or column name of \code{expData}. Pruning is inspected for the neighbourhood of this cell.}

\item{expData}{Matrix of gene expression values with genes as rows and cells as columns. These values have to correspond to unique molecular identifier counts.}

\item{res}{List object with k nearest neighbour information returned by \code{pruneKnn} function.}

\item{cl}{List object with clustering information, returned by the \code{graphCluster} function.}

\item{object}{\code{SCseq} class object. Required if \code{plotSymbol} is \code{TRUE}. Default is \code{NULL}.}

\item{nb}{Input parameter of \code{pruneKnn}. See \code{help(pruneKnn)}. Default is res$pars$nb.}

\item{pvalue}{Positive real number between 0 and 1. All nearest neighbours with link probability \code{< pvalue} are pruned. Default is 0.01.}

\item{backModel}{Optional background model. Second order polynomial fitting the mean-variance dpendence on log2 scales as returned by \code{lm}. Default is \code{NULL} and the local background model is computed as in \code{pruneKnn}.}

\item{alpha}{Input parameter of \code{pruneKnn}. See \code{help(pruneKnn)}. Default is res$pars$alpha.}

\item{plotSymbol}{Logical. If \code{TRUE} then a dimensional reduction representation is plotted highlighting cell \code{i}, all k nearest neighbours, all outliers, and the stringest outlier in different colours. Function \code{plotsymbolsmap} is used. Additional parameter for this function, such as \code{um=TRUE} can be given. Default is \code{FALSE}, and the local mean-variance dependence is plotted along with a second order polynomial fit and a local regression. See \code{plotMV}.}

\item{id}{Valid column name of expData. If \code{plotSymbol=TRUE} this corresponding cell is highlighted in the dimensional reduction representation.}

\item{degree}{Input parameter for mean-variance fit. See \code{plotMV}.}

\item{span}{Input parameter for mean-variance fit. See \code{plotMV}.}

\item{cv}{Input parameter for mean-variance fit. See \code{plotMV}.}

\item{...}{Additional parameters for \code{plotsymbolsmap}.}
}
\value{
List object with six components:
\item{pv.neighbours.cell}{Vector of outlier p-values (Bonferroni-corrected) for each of the k-nearest neighbours.}
\item{cluster.neighours}{Vector of cluster numbers for central cell and each of the k-nearest neighbours.}
\item{alpha}{\code{alpha} parameter used for pruning.}
\item{expr.neighbours}{Matrix of normalized transcript counts for the central cell and each of the k-nearest neighbours (normalized to the minimum number of total trascript counts across all neighours). Additional columns indicate inferred local mean, standard deviation, and strongest outlier p-value. Rows are sorted by p-values of the strongest outlier cell in increasing order. }
\item{pv.neighbours}{Matrix of outlier p-values of all genes for the central cells and each of the k-nearest neighbours. Rows are sorted by p-values of the strongest outlier cell in increasing order.}
\item{strongest.outlier}{Column name of strongest outlier.}
}
\description{
This function allows inspection of the local background model and the pruning of nearest neighbours for a given cell. A dimensional reduction representation is plotted where k nearest neighours and outliers are highlighted. Alternatively, the dependence of the transcript count variance or, alternatively, the coefficient of variation (CV) on the mean in log2 space is plotted. The  mean-variance dependence is plotted along with a loess-regression, a second order polynomial fit, and the background model of the local variability. The CV plot also highlights the local variability associated with cell-to-cell variability of total transcript counts, as calculated directly from the mean and variance of total transcript counts (turquoise) or from a local fit of a gamma distribution (orange).
}
