% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpm_split.R
\name{mpm_split}
\alias{mpm_split}
\title{Convert matrix population model into U, F and C matrices}
\usage{
mpm_split(matA)
}
\arguments{
\item{matA}{A matrix population model (i.e., a square projection matrix).}
}
\value{
A list of three matrices: \code{matU},\code{matF} and \code{matC}.
\code{matC} will always contain only zeros.
}
\description{
Splits a matrix population model into three constituent matrices, \bold{U}
(growth and survival processes), \bold{F} (sexual reproduction) and \bold{C}
(clonal reproduction). \strong{Warning!} The functionality is very basic: it
assumes that sexual reproduction is located in the top row of the matrix, and
that everything else is growth or survival (i.e. the \bold{U} matrix).
Clonality is assumed to be non-existent.
}
\examples{
matA <- rbind(
  c(0.1, 0, 5.3, 4.2),
  c(0.5, 0.2, 0.1, 0),
  c(0, 0.3, 0.3, 0.1),
  c(0, 0, 0.5, 0.6)
)

mpm_split(matA)

}
\seealso{
Other transformation: 
\code{\link{mpm_collapse}()},
\code{\link{mpm_rearrange}()},
\code{\link{mpm_standardize}()},
\code{\link{name_stages}()},
\code{\link{repro_stages}()},
\code{\link{standard_stages}()}
}
\author{
Owen R. Jones <jones@biology.sdu.dk>
}
\concept{transformation}
