% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leslie_collapse.R
\name{leslie_collapse}
\alias{leslie_collapse}
\title{Aggregate a Leslie matrix}
\usage{
leslie_collapse(A, m)
}
\arguments{
\item{A}{a Leslie matrix}

\item{m}{the dimensionality of the desired aggregated matrix}
}
\value{
a list including the following elements:
\item{B}{The aggregated matrix}
\item{W}{The weight matrix}
\item{Ak}{The original (or expanded) Leslie matrix raised to the k power}
\item{S}{The partitioning matrix}
\item{n}{The size of the original (or expanded) Leslie matrix}
\item{m}{The size of the aggregated matrix}
\item{k}{The quotient of the original size divided by the aggregated size}
\item{EFF}{The effectiveness of aggregation}
}
\description{
Takes a Leslie matrix and aggregates it to a desired dimension m using least
squares weights equal to the stable age distribution. The output includes the
aggregated matrix, the weight matrix, the original (or expanded) Leslie
matrix raised to the k power, the partitioning matrix, the size of the
original (or expanded) Leslie matrix, the size of the aggregated matrix, the
quotient of the original size divided by the aggregated size, and the
effectiveness of aggregation.
}
\examples{
data(leslie_mpm1)
A <- leslie_mpm1$matU + leslie_mpm1$matF
leslie_collapse(A, 4)

}
\references{
Hinrichsen, R. A. (2023). Aggregation of Leslie matrix models
  with application to ten diverse animal species. Population Ecology, 1–21.
  https://doi.org/10.1002/1438-390X.12149
}
\seealso{
Other transformation: 
\code{\link{is_leslie_matrix}()},
\code{\link{mpm_collapse}()},
\code{\link{mpm_rearrange}()},
\code{\link{mpm_split}()},
\code{\link{mpm_standardize}()},
\code{\link{name_stages}()},
\code{\link{repro_stages}()},
\code{\link{standard_stages}()}
}
\author{
Richard A. Hinrichsen <rich@hinrichsenenvironmental.com>
}
\concept{transformation}
