% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_surv.R
\name{shape_surv}
\alias{shape_surv}
\title{Calculate shape of survival over age}
\usage{
shape_surv(surv, xmin = NULL, xmax = NULL, trunc = FALSE, ...)
}
\arguments{
\item{surv}{Either 1) a numeric vector describing a survival curve (lx), 2) a
  \code{data.frame} / \code{list} with one column / element titled 'lx'
  describing a survival curve, optionally a column / element 'x' containing
  age classes (each element a number representing the age at the start of the
  class), or 3), a \code{matrix}, specifically the U submatrix of a matrix
  population model (A).

  In case (2) If \code{x} is not supplied, the function will assume age
  classes starting at \code{0} with time steps of \code{1} unit of the
  \code{ProjectionInterval}. If \code{x} begins at \code{0} then \code{lx[1]}
  should equal \code{1}. If \code{x} ends at maximum longevity, then
  \code{lx[which.max(x)]} should equal \code{0}; however it is possible to
  supply partial survivorship curves.}

\item{xmin, xmax}{The minimum and maximum age respectively over which to
evaluate shape. If not given, these default to \code{min(x)} and
\code{max(x)} respectively.}

\item{trunc}{logical determining whether to truncate life tables or not when
any \code{lx == 0}. Usually this is the case only for the final value of
\code{lx}. As the function calculates \code{log(lx)}, these value(s) cannot
be handled. \code{trunc == TRUE} strips out the zero value(s). An
alternative to this is to transform the zeroes to something approximating
zero (e.g., 1e-7).}

\item{...}{Additional variables passed to `mpm_to_lx`, if data are supplied
as a matrix.}
}
\value{
a shape value describing lifespan inequality by comparing the area
  under a survival (\code{lx}) curve over age with the area under a constant
  (Type II) survival function. The shape value may take any real value
  between -0.5 and +0.5. A value of 0 indicates negligible ageing (neither
  generally increasing nor generally decreasing survival with age); negative
  values indicate negative senescence (generally increasing survival with
  age); positive values indicate senescence (generally decreasing survival
  with age). A value of +0.5 indicates that all individuals die at age of
  maximum longevity; a value of -0.5 indicates that (hypothetically) all
  individuals die at birth.
}
\description{
Calculates a 'shape' value of survival lifespan inequality by comparing the
area under a survival curve (over age) with the area under a constant
survival function.
}
\examples{
# exponential decline in lx yields shape = 0
lx <- 0.7^(0:20)
shape_surv(lx)

data(mpm1)
shape_surv(mpm1$matU)

lx <- mpm_to_lx(mpm1$matU, start = 1)
shape_surv(lx)

}
\seealso{
Other life history traits: 
\code{\link{entropy_d}()},
\code{\link{entropy_k}()},
\code{\link{gen_time}()},
\code{\link{life_expect_mean}()},
\code{\link{longevity}()},
\code{\link{net_repro_rate}()},
\code{\link{repro_maturity}},
\code{\link{shape_rep}()}
}
\author{
Iain Stott <iainmstott@gmail.com>
}
\concept{life history traits}
