% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_annual_quantiles.R
\name{rvn_annual_quantiles}
\alias{rvn_annual_quantiles}
\title{Calculates Yearly Median, Upper and Lower Quantiles of Flow}
\usage{
rvn_annual_quantiles(
  hgdata,
  prd = NULL,
  Qlower = 0.1,
  Qupper = 0.9,
  water_year = TRUE,
  mm = 9
)
}
\arguments{
\item{hgdata}{Time series object of observed or simulated flows}

\item{prd}{time period for subset in character format "YYYY-MM-DD/YYYY-MM-DD"}

\item{Qlower}{Decimal percentage of lower quantile value (default 0.1)}

\item{Qupper}{Decimal percentage of upper quantile value (default 0.9)}

\item{water_year}{booolean on whether to sort quantiles by water year start date (default TRUE)}

\item{mm}{month of water year ending (default 9)}
}
\value{
\item{qdat}{Time series object of monthly median and quantile values}
}
\description{
Calculate the quantiles for each day of the year based on the supplied time series.
}
\examples{
system.file("extdata","run1_Hydrographs.csv", package="RavenR") \%>\%
rvn_hyd_read(.) \%>\%
rvn_hyd_extract(subs="Sub36",.) ->
hyd_data

# Calculate quantiles for the simulated hydrograph
qdat <- rvn_annual_quantiles(hyd_data$sim)
head(qdat)

}
\author{
Leland Scantlebury, \email{leland@scantle.com}
}
