% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/portfolio.R
\name{getPortfolio}
\alias{getPortfolio}
\title{Run 'Portfolio Data' Queries}
\usage{
getPortfolio(security, field, options = NULL, overrides = NULL,
  verbose = FALSE, identity = NULL, con = defaultConnection())
}
\arguments{
\item{security}{A character value with a single security symbol in
Bloomberg notation.}

\item{field}{A character string with a single Bloomberg query field.}

\item{options}{An optional named character vector with option
values. Each field must have both a name (designating the option
being set) as well as a value.}

\item{overrides}{An optional named character vector with override
values. Each field must have both a name (designating the override
being set) as well as a value.}

\item{verbose}{A boolean indicating whether verbose operation is
desired, defaults to \sQuote{FALSE}}

\item{identity}{An optional identity object.}

\item{con}{A connection object as created by a \code{blpConnect}
call, and retrieved via the internal function
\code{defaultConnection}.}
}
\value{
A list with as many entries as there are entries in
\code{securities}; each list contains a data.frame with one row
per observations and as many columns as entries in
\code{fields}. If the list is of length one, it is collapsed into
a single data frame.
}
\description{
This function uses the Bloomberg API to retrieve 'portfolio' queries
}
\author{
John Laing
}

