% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleCompute.R
\name{countItemsSampleGUI}
\alias{countItemsSampleGUI}
\title{GUI to manually count the number of cells in colonies}
\usage{
countItemsSampleGUI(data.sample, RclusTool.env = initParameters())
}
\arguments{
\item{data.sample}{list containing features, profiles and clustering results.}

\item{RclusTool.env}{environment in which all global parameters, raw data and results are stored.}
}
\value{
RDS file containing the counts.
}
\description{
Open a Graphical User Interface allowing to choose the images directory, to count manually the number of cells in colonies and to build specific predictive model.
}
\details{
countItemsSampleGUI opens a Graphical User Interface allowing to choose the images directory, to count manually the number of cells in colonies and to build specific predictive model
}
\examples{
\donttest{ 
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")
x <- importSample(file.features=tf)

x <- computeUnSupervised(x, K=0, pca=TRUE, echo=TRUE)
countResult <- countItemsSampleGUI(x)
}
}
\keyword{internal}
