% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdb_build_cdb.R
\name{cdb_build_cdb}
\alias{cdb_build_cdb}
\title{Create a CompadreDB object from user-specified data}
\usage{
cdb_build_cdb(
  mat_a = NULL,
  mat_u = NULL,
  mat_f = NULL,
  mat_c = NULL,
  stages = NULL,
  version = NULL,
  metadata = NULL
)
}
\arguments{
\item{mat_a}{A `list` of A matrices}

\item{mat_u}{A `list` of U matrices (representing survival and growth)}

\item{mat_f}{A `list` of F matrices (representing sexual reproduction)}

\item{mat_c}{A `list` of C matrices (representing clonal reproduction)}

\item{stages}{A `list` of stage definitions provided as `data.frame`s that
include two columns: `MatrixClassOrganized` and `MatrixClassAuthor`. If
this argument is not provided, numeric stage names are generated
automatically}

\item{version}{An optional string allowing users to add version information
to their output object. If this argument is not provided the current date
and time is used.}

\item{metadata}{A `data.frame` of metadata associated with each matrix.
Metadata should be provided by row in the same order as the matrices are
placed in the lists.}
}
\value{
A valid CompadreDB object
}
\description{
Creates a CompadreDB object from data provided by the user in the form of
matrices and metadata. Users can provide either a list of A matrices (i.e.
the whole matrix population model) or lists of process-based submatrices
\code{matU}, \code{matF}and \code{matC}. In this latter case, we assume that
\code{matA = matU + matF + matC}. If only one type of the submatrices are
provided, the others are assumed to be 0. If only the A matrices are
provided, the submatrices are recorded as `NA`.
}
\examples{
# If you only have A matrices

mat_a1 <- rbind(
  c(0.1, 1.9),
  c(0.5, 0.7)
)

mat_a2 <- rbind(
  c(0.2, 1.4, 2.3),
  c(0.6, 0.3, 1.1),
  c(0.2, 0.2, 1.5)
)

mat_a3 <- rbind(
  c(0.1, 2.1),
  c(0.3, 0.4)
)

# Place the matrices into a list
mat_a_list <- mget(ls(pattern = "mat_a[0-9]"))

my_compadre <- cdb_build_cdb(mat_a = mat_a_list, version = "testrun")
my_compadre


mat_u1 <- rbind(
  c(0.1, 0.0),
  c(0.5, 0.7)
)

mat_u2 <- rbind(
  c(0.2, 0.0, 0.0),
  c(0.6, 0.3, 1.1),
  c(0.2, 0.2, 1.5)
)

mat_f1 <- rbind(
  c(0.0, 1.9),
  c(0.0, 0.0)
)

mat_f2 <- rbind(
  c(0.0, 1.4, 2.3),
  c(0.0, 0.0, 0.0),
  c(0.0, 0.0, 0.0)
)

mat_u_list <- mget(ls(pattern = "mat_u[0-9]"))
mat_f_list <- mget(ls(pattern = "mat_f[0-9]"))

meta <- data.frame(idNum = 1:2, SpeciesAccepted = c("A", "B"), x = 4:5)

stageInfo <- list(
  data.frame(
    MatrixClassOrganized = rep("active", 2),
    MatrixClassAuthor = c("small", "large")
  ),
  data.frame(
    MatrixClassOrganized = rep("active", 3),
    MatrixClassAuthor = c("small", "medium", "large")
  )
)


my_compadre <- cdb_build_cdb(
  mat_u = mat_u_list, mat_f = mat_f_list,
  metadata = meta, stages = stageInfo
)
my_compadre

my_compadre <- cdb_build_cdb(
  mat_u = mat_u_list, mat_f = mat_f_list,
  metadata = meta
)
my_compadre
}
\seealso{
Other data acquisition: 
\code{\link{cdb_fetch}()},
\code{\link{cdb_metadata}()}
}
\author{
Owen R. Jones <jones@biology.sdu.dk>
}
\concept{data acquisition}
